%------------------------------------------------------------------------------
% File     : ITP101^1 : TPTP v9.2.0. Released v7.5.0.
% Domain   : Interactive Theorem Proving
% Problem  : Sledgehammer ListInf problem prob_63__5408460_1
% Version  : Especial.
% English  :

% Refs     : [BH+15] Blanchette et al. (2015), Mining the Archive of Formal
%          : [Des21] Desharnais (2021), Email to Geoff Sutcliffe
% Source   : [Des21]
% Names    : ListInf/prob_63__5408460_1 [Des21]

% Status   : Theorem
% Rating   : 0.11 v9.1.0, 0.12 v9.0.0, 0.20 v8.2.0, 0.08 v8.1.0, 0.09 v7.5.0
% Syntax   : Number of formulae    :  308 (  88 unt;  41 typ;   0 def)
%            Number of atoms       :  785 ( 279 equ;   0 cnn)
%            Maximal formula atoms :   12 (   2 avg)
%            Number of connectives : 2464 (  92   ~;  26   |;  43   &;1920   @)
%                                         (   0 <=>; 383  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   18 (   7 avg)
%            Number of types       :    7 (   6 usr)
%            Number of type conns  :  128 ( 128   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   38 (  35 usr;   6 con; 0-3 aty)
%            Number of variables   :  816 (  71   ^; 704   !;  41   ?; 816   :)
% SPC      : TH0_THM_EQU_NAR

% Comments : This file was generated by Sledgehammer 2021-02-23 15:30:16.735
%------------------------------------------------------------------------------
% Could-be-implicit typings (6)
thf(ty_n_t__List__Olist_It__Nat__Onat_J,type,
    list_nat: $tType ).

thf(ty_n_t__Set__Oset_It__Nat__Onat_J,type,
    set_nat: $tType ).

thf(ty_n_t__List__Olist_Itf__a_J,type,
    list_a: $tType ).

thf(ty_n_t__Set__Oset_Itf__a_J,type,
    set_a: $tType ).

thf(ty_n_t__Nat__Onat,type,
    nat: $tType ).

thf(ty_n_tf__a,type,
    a: $tType ).

% Explicit typings (35)
thf(sy_c_Groups_Ominus__class_Ominus_001t__Nat__Onat,type,
    minus_minus_nat: nat > nat > nat ).

thf(sy_c_Groups_Oone__class_Oone_001t__Nat__Onat,type,
    one_one_nat: nat ).

thf(sy_c_If_001t__Nat__Onat,type,
    if_nat: $o > nat > nat > nat ).

thf(sy_c_If_001tf__a,type,
    if_a: $o > a > a > a ).

thf(sy_c_List2_Olist__asc_001t__Nat__Onat,type,
    list_asc_nat: list_nat > $o ).

thf(sy_c_List2_Olist__desc_001t__Nat__Onat,type,
    list_desc_nat: list_nat > $o ).

thf(sy_c_List2_Olist__strict__asc_001t__Nat__Onat,type,
    list_strict_asc_nat: list_nat > $o ).

thf(sy_c_List2_Olist__strict__desc_001t__Nat__Onat,type,
    list_strict_desc_nat: list_nat > $o ).

thf(sy_c_ListInf__Mirabelle__akbajwqfbr_Oi__append_001t__Nat__Onat,type,
    listIn923761578nd_nat: list_nat > ( nat > nat ) > nat > nat ).

thf(sy_c_ListInf__Mirabelle__akbajwqfbr_Oi__append_001tf__a,type,
    listIn1312259492pend_a: list_a > ( nat > a ) > nat > a ).

thf(sy_c_List_Oappend_001t__Nat__Onat,type,
    append_nat: list_nat > list_nat > list_nat ).

thf(sy_c_List_Oappend_001tf__a,type,
    append_a: list_a > list_a > list_a ).

thf(sy_c_List_Obutlast_001t__Nat__Onat,type,
    butlast_nat: list_nat > list_nat ).

thf(sy_c_List_Obutlast_001tf__a,type,
    butlast_a: list_a > list_a ).

thf(sy_c_List_Olist_Oset_001t__Nat__Onat,type,
    set_nat2: list_nat > set_nat ).

thf(sy_c_List_Olist_Oset_001tf__a,type,
    set_a2: list_a > set_a ).

thf(sy_c_List_Olist__ex_001t__Nat__Onat,type,
    list_ex_nat: ( nat > $o ) > list_nat > $o ).

thf(sy_c_List_Olist__ex_001tf__a,type,
    list_ex_a: ( a > $o ) > list_a > $o ).

thf(sy_c_List_Olist__update_001t__Nat__Onat,type,
    list_update_nat: list_nat > nat > nat > list_nat ).

thf(sy_c_List_Olist__update_001tf__a,type,
    list_update_a: list_a > nat > a > list_a ).

thf(sy_c_List_Onth_001t__Nat__Onat,type,
    nth_nat: list_nat > nat > nat ).

thf(sy_c_List_Onth_001tf__a,type,
    nth_a: list_a > nat > a ).

thf(sy_c_Nat_Osize__class_Osize_001t__List__Olist_It__Nat__Onat_J,type,
    size_size_list_nat: list_nat > nat ).

thf(sy_c_Nat_Osize__class_Osize_001t__List__Olist_Itf__a_J,type,
    size_size_list_a: list_a > nat ).

thf(sy_c_Orderings_Oord__class_Oless_001t__Nat__Onat,type,
    ord_less_nat: nat > nat > $o ).

thf(sy_c_Orderings_Oord__class_Oless__eq_001t__Nat__Onat,type,
    ord_less_eq_nat: nat > nat > $o ).

thf(sy_c_Orderings_Oord__class_Oless__eq_001t__Set__Oset_Itf__a_J,type,
    ord_less_eq_set_a: set_a > set_a > $o ).

thf(sy_c_Set_OCollect_001tf__a,type,
    collect_a: ( a > $o ) > set_a ).

thf(sy_c_member_001t__Nat__Onat,type,
    member_nat: nat > set_nat > $o ).

thf(sy_c_member_001tf__a,type,
    member_a: a > set_a > $o ).

thf(sy_v_f,type,
    f: nat > a ).

thf(sy_v_g,type,
    g: nat > a ).

thf(sy_v_x,type,
    x: nat ).

thf(sy_v_xs,type,
    xs: list_a ).

thf(sy_v_ys,type,
    ys: list_a ).

% Relevant facts (258)
thf(fact_0_nth__equalityI,axiom,
    ! [Xs: list_nat,Ys: list_nat] :
      ( ( ( size_size_list_nat @ Xs )
        = ( size_size_list_nat @ Ys ) )
     => ( ! [I: nat] :
            ( ( ord_less_nat @ I @ ( size_size_list_nat @ Xs ) )
           => ( ( nth_nat @ Xs @ I )
              = ( nth_nat @ Ys @ I ) ) )
       => ( Xs = Ys ) ) ) ).

% nth_equalityI
thf(fact_1_nth__equalityI,axiom,
    ! [Xs: list_a,Ys: list_a] :
      ( ( ( size_size_list_a @ Xs )
        = ( size_size_list_a @ Ys ) )
     => ( ! [I: nat] :
            ( ( ord_less_nat @ I @ ( size_size_list_a @ Xs ) )
           => ( ( nth_a @ Xs @ I )
              = ( nth_a @ Ys @ I ) ) )
       => ( Xs = Ys ) ) ) ).

% nth_equalityI
thf(fact_2_Skolem__list__nth,axiom,
    ! [K: nat,P: nat > nat > $o] :
      ( ( ! [I2: nat] :
            ( ( ord_less_nat @ I2 @ K )
           => ? [X: nat] : ( P @ I2 @ X ) ) )
      = ( ? [Xs2: list_nat] :
            ( ( ( size_size_list_nat @ Xs2 )
              = K )
            & ! [I2: nat] :
                ( ( ord_less_nat @ I2 @ K )
               => ( P @ I2 @ ( nth_nat @ Xs2 @ I2 ) ) ) ) ) ) ).

% Skolem_list_nth
thf(fact_3_Skolem__list__nth,axiom,
    ! [K: nat,P: nat > a > $o] :
      ( ( ! [I2: nat] :
            ( ( ord_less_nat @ I2 @ K )
           => ? [X: a] : ( P @ I2 @ X ) ) )
      = ( ? [Xs2: list_a] :
            ( ( ( size_size_list_a @ Xs2 )
              = K )
            & ! [I2: nat] :
                ( ( ord_less_nat @ I2 @ K )
               => ( P @ I2 @ ( nth_a @ Xs2 @ I2 ) ) ) ) ) ) ).

% Skolem_list_nth
thf(fact_4_list__eq__iff__nth__eq,axiom,
    ( ( ^ [Y: list_nat,Z: list_nat] : ( Y = Z ) )
    = ( ^ [Xs2: list_nat,Ys2: list_nat] :
          ( ( ( size_size_list_nat @ Xs2 )
            = ( size_size_list_nat @ Ys2 ) )
          & ! [I2: nat] :
              ( ( ord_less_nat @ I2 @ ( size_size_list_nat @ Xs2 ) )
             => ( ( nth_nat @ Xs2 @ I2 )
                = ( nth_nat @ Ys2 @ I2 ) ) ) ) ) ) ).

% list_eq_iff_nth_eq
thf(fact_5_list__eq__iff__nth__eq,axiom,
    ( ( ^ [Y: list_a,Z: list_a] : ( Y = Z ) )
    = ( ^ [Xs2: list_a,Ys2: list_a] :
          ( ( ( size_size_list_a @ Xs2 )
            = ( size_size_list_a @ Ys2 ) )
          & ! [I2: nat] :
              ( ( ord_less_nat @ I2 @ ( size_size_list_a @ Xs2 ) )
             => ( ( nth_a @ Xs2 @ I2 )
                = ( nth_a @ Ys2 @ I2 ) ) ) ) ) ) ).

% list_eq_iff_nth_eq
thf(fact_6_i__append__nth1,axiom,
    ! [N: nat,Xs: list_nat,F: nat > nat] :
      ( ( ord_less_nat @ N @ ( size_size_list_nat @ Xs ) )
     => ( ( listIn923761578nd_nat @ Xs @ F @ N )
        = ( nth_nat @ Xs @ N ) ) ) ).

% i_append_nth1
thf(fact_7_i__append__nth1,axiom,
    ! [N: nat,Xs: list_a,F: nat > a] :
      ( ( ord_less_nat @ N @ ( size_size_list_a @ Xs ) )
     => ( ( listIn1312259492pend_a @ Xs @ F @ N )
        = ( nth_a @ Xs @ N ) ) ) ).

% i_append_nth1
thf(fact_8_diff__less__mono2,axiom,
    ! [M: nat,N: nat,L: nat] :
      ( ( ord_less_nat @ M @ N )
     => ( ( ord_less_nat @ M @ L )
       => ( ord_less_nat @ ( minus_minus_nat @ L @ N ) @ ( minus_minus_nat @ L @ M ) ) ) ) ).

% diff_less_mono2
thf(fact_9_less__imp__diff__less,axiom,
    ! [J: nat,K: nat,N: nat] :
      ( ( ord_less_nat @ J @ K )
     => ( ord_less_nat @ ( minus_minus_nat @ J @ N ) @ K ) ) ).

% less_imp_diff_less
thf(fact_10_less__diff__imp__less,axiom,
    ! [I3: nat,J: nat,M: nat] :
      ( ( ord_less_nat @ I3 @ ( minus_minus_nat @ J @ M ) )
     => ( ord_less_nat @ I3 @ J ) ) ).

% less_diff_imp_less
thf(fact_11_nat__diff__left__cancel__eq1,axiom,
    ! [K: nat,M: nat,N: nat] :
      ( ( ( minus_minus_nat @ K @ M )
        = ( minus_minus_nat @ K @ N ) )
     => ( ( ord_less_nat @ M @ K )
       => ( M = N ) ) ) ).

% nat_diff_left_cancel_eq1
thf(fact_12_nat__diff__left__cancel__eq2,axiom,
    ! [K: nat,M: nat,N: nat] :
      ( ( ( minus_minus_nat @ K @ M )
        = ( minus_minus_nat @ K @ N ) )
     => ( ( ord_less_nat @ N @ K )
       => ( M = N ) ) ) ).

% nat_diff_left_cancel_eq2
thf(fact_13_nat__diff__left__cancel__less,axiom,
    ! [K: nat,M: nat,N: nat] :
      ( ( ord_less_nat @ ( minus_minus_nat @ K @ M ) @ ( minus_minus_nat @ K @ N ) )
     => ( ord_less_nat @ N @ M ) ) ).

% nat_diff_left_cancel_less
thf(fact_14_nat__diff__right__cancel__eq1,axiom,
    ! [M: nat,K: nat,N: nat] :
      ( ( ( minus_minus_nat @ M @ K )
        = ( minus_minus_nat @ N @ K ) )
     => ( ( ord_less_nat @ K @ M )
       => ( M = N ) ) ) ).

% nat_diff_right_cancel_eq1
thf(fact_15_linorder__neqE__nat,axiom,
    ! [X2: nat,Y2: nat] :
      ( ( X2 != Y2 )
     => ( ~ ( ord_less_nat @ X2 @ Y2 )
       => ( ord_less_nat @ Y2 @ X2 ) ) ) ).

% linorder_neqE_nat
thf(fact_16_infinite__descent,axiom,
    ! [P: nat > $o,N: nat] :
      ( ! [N2: nat] :
          ( ~ ( P @ N2 )
         => ? [M2: nat] :
              ( ( ord_less_nat @ M2 @ N2 )
              & ~ ( P @ M2 ) ) )
     => ( P @ N ) ) ).

% infinite_descent
thf(fact_17_nat__less__induct,axiom,
    ! [P: nat > $o,N: nat] :
      ( ! [N2: nat] :
          ( ! [M2: nat] :
              ( ( ord_less_nat @ M2 @ N2 )
             => ( P @ M2 ) )
         => ( P @ N2 ) )
     => ( P @ N ) ) ).

% nat_less_induct
thf(fact_18_less__irrefl__nat,axiom,
    ! [N: nat] :
      ~ ( ord_less_nat @ N @ N ) ).

% less_irrefl_nat
thf(fact_19_less__not__refl3,axiom,
    ! [S: nat,T: nat] :
      ( ( ord_less_nat @ S @ T )
     => ( S != T ) ) ).

% less_not_refl3
thf(fact_20_less__not__refl2,axiom,
    ! [N: nat,M: nat] :
      ( ( ord_less_nat @ N @ M )
     => ( M != N ) ) ).

% less_not_refl2
thf(fact_21_less__not__refl,axiom,
    ! [N: nat] :
      ~ ( ord_less_nat @ N @ N ) ).

% less_not_refl
thf(fact_22_nat__neq__iff,axiom,
    ! [M: nat,N: nat] :
      ( ( M != N )
      = ( ( ord_less_nat @ M @ N )
        | ( ord_less_nat @ N @ M ) ) ) ).

% nat_neq_iff
thf(fact_23_size__neq__size__imp__neq,axiom,
    ! [X2: list_nat,Y2: list_nat] :
      ( ( ( size_size_list_nat @ X2 )
       != ( size_size_list_nat @ Y2 ) )
     => ( X2 != Y2 ) ) ).

% size_neq_size_imp_neq
thf(fact_24_size__neq__size__imp__neq,axiom,
    ! [X2: list_a,Y2: list_a] :
      ( ( ( size_size_list_a @ X2 )
       != ( size_size_list_a @ Y2 ) )
     => ( X2 != Y2 ) ) ).

% size_neq_size_imp_neq
thf(fact_25_neq__if__length__neq,axiom,
    ! [Xs: list_nat,Ys: list_nat] :
      ( ( ( size_size_list_nat @ Xs )
       != ( size_size_list_nat @ Ys ) )
     => ( Xs != Ys ) ) ).

% neq_if_length_neq
thf(fact_26_neq__if__length__neq,axiom,
    ! [Xs: list_a,Ys: list_a] :
      ( ( ( size_size_list_a @ Xs )
       != ( size_size_list_a @ Ys ) )
     => ( Xs != Ys ) ) ).

% neq_if_length_neq
thf(fact_27_Ex__list__of__length,axiom,
    ! [N: nat] :
    ? [Xs3: list_nat] :
      ( ( size_size_list_nat @ Xs3 )
      = N ) ).

% Ex_list_of_length
thf(fact_28_Ex__list__of__length,axiom,
    ! [N: nat] :
    ? [Xs3: list_a] :
      ( ( size_size_list_a @ Xs3 )
      = N ) ).

% Ex_list_of_length
thf(fact_29_eq__imp__diff__eq,axiom,
    ! [M: nat,N: nat,K: nat] :
      ( ( M = N )
     => ( ( minus_minus_nat @ M @ K )
        = ( minus_minus_nat @ N @ K ) ) ) ).

% eq_imp_diff_eq
thf(fact_30_diff__commute,axiom,
    ! [I3: nat,J: nat,K: nat] :
      ( ( minus_minus_nat @ ( minus_minus_nat @ I3 @ J ) @ K )
      = ( minus_minus_nat @ ( minus_minus_nat @ I3 @ K ) @ J ) ) ).

% diff_commute
thf(fact_31_i__append__nth,axiom,
    ( listIn923761578nd_nat
    = ( ^ [Xs2: list_nat,F2: nat > nat,N3: nat] : ( if_nat @ ( ord_less_nat @ N3 @ ( size_size_list_nat @ Xs2 ) ) @ ( nth_nat @ Xs2 @ N3 ) @ ( F2 @ ( minus_minus_nat @ N3 @ ( size_size_list_nat @ Xs2 ) ) ) ) ) ) ).

% i_append_nth
thf(fact_32_i__append__nth,axiom,
    ( listIn1312259492pend_a
    = ( ^ [Xs2: list_a,F2: nat > a,N3: nat] : ( if_a @ ( ord_less_nat @ N3 @ ( size_size_list_a @ Xs2 ) ) @ ( nth_a @ Xs2 @ N3 ) @ ( F2 @ ( minus_minus_nat @ N3 @ ( size_size_list_a @ Xs2 ) ) ) ) ) ) ).

% i_append_nth
thf(fact_33_i__append__def,axiom,
    ( listIn923761578nd_nat
    = ( ^ [Xs2: list_nat,F2: nat > nat,N3: nat] : ( if_nat @ ( ord_less_nat @ N3 @ ( size_size_list_nat @ Xs2 ) ) @ ( nth_nat @ Xs2 @ N3 ) @ ( F2 @ ( minus_minus_nat @ N3 @ ( size_size_list_nat @ Xs2 ) ) ) ) ) ) ).

% i_append_def
thf(fact_34_i__append__def,axiom,
    ( listIn1312259492pend_a
    = ( ^ [Xs2: list_a,F2: nat > a,N3: nat] : ( if_a @ ( ord_less_nat @ N3 @ ( size_size_list_a @ Xs2 ) ) @ ( nth_a @ Xs2 @ N3 ) @ ( F2 @ ( minus_minus_nat @ N3 @ ( size_size_list_a @ Xs2 ) ) ) ) ) ) ).

% i_append_def
thf(fact_35_length__induct,axiom,
    ! [P: list_nat > $o,Xs: list_nat] :
      ( ! [Xs3: list_nat] :
          ( ! [Ys3: list_nat] :
              ( ( ord_less_nat @ ( size_size_list_nat @ Ys3 ) @ ( size_size_list_nat @ Xs3 ) )
             => ( P @ Ys3 ) )
         => ( P @ Xs3 ) )
     => ( P @ Xs ) ) ).

% length_induct
thf(fact_36_length__induct,axiom,
    ! [P: list_a > $o,Xs: list_a] :
      ( ! [Xs3: list_a] :
          ( ! [Ys3: list_a] :
              ( ( ord_less_nat @ ( size_size_list_a @ Ys3 ) @ ( size_size_list_a @ Xs3 ) )
             => ( P @ Ys3 ) )
         => ( P @ Xs3 ) )
     => ( P @ Xs ) ) ).

% length_induct
thf(fact_37_nat__diff__right__cancel__less,axiom,
    ! [N: nat,K: nat,M: nat] :
      ( ( ord_less_nat @ ( minus_minus_nat @ N @ K ) @ ( minus_minus_nat @ M @ K ) )
     => ( ord_less_nat @ N @ M ) ) ).

% nat_diff_right_cancel_less
thf(fact_38_nat__diff__right__cancel__eq2,axiom,
    ! [M: nat,K: nat,N: nat] :
      ( ( ( minus_minus_nat @ M @ K )
        = ( minus_minus_nat @ N @ K ) )
     => ( ( ord_less_nat @ K @ N )
       => ( M = N ) ) ) ).

% nat_diff_right_cancel_eq2
thf(fact_39_list__strict__desc__trans,axiom,
    ( list_strict_desc_nat
    = ( ^ [Xs2: list_nat] :
        ! [J2: nat] :
          ( ( ord_less_nat @ J2 @ ( size_size_list_nat @ Xs2 ) )
         => ! [I2: nat] :
              ( ( ord_less_nat @ I2 @ J2 )
             => ( ord_less_nat @ ( nth_nat @ Xs2 @ J2 ) @ ( nth_nat @ Xs2 @ I2 ) ) ) ) ) ) ).

% list_strict_desc_trans
thf(fact_40_list__strict__asc__trans,axiom,
    ( list_strict_asc_nat
    = ( ^ [Xs2: list_nat] :
        ! [J2: nat] :
          ( ( ord_less_nat @ J2 @ ( size_size_list_nat @ Xs2 ) )
         => ! [I2: nat] :
              ( ( ord_less_nat @ I2 @ J2 )
             => ( ord_less_nat @ ( nth_nat @ Xs2 @ I2 ) @ ( nth_nat @ Xs2 @ J2 ) ) ) ) ) ) ).

% list_strict_asc_trans
thf(fact_41_list__ex__length,axiom,
    ( list_ex_nat
    = ( ^ [P2: nat > $o,Xs2: list_nat] :
        ? [N3: nat] :
          ( ( ord_less_nat @ N3 @ ( size_size_list_nat @ Xs2 ) )
          & ( P2 @ ( nth_nat @ Xs2 @ N3 ) ) ) ) ) ).

% list_ex_length
thf(fact_42_list__ex__length,axiom,
    ( list_ex_a
    = ( ^ [P2: a > $o,Xs2: list_a] :
        ? [N3: nat] :
          ( ( ord_less_nat @ N3 @ ( size_size_list_a @ Xs2 ) )
          & ( P2 @ ( nth_a @ Xs2 @ N3 ) ) ) ) ) ).

% list_ex_length
thf(fact_43_i__append__nth2,axiom,
    ! [Xs: list_nat,N: nat,F: nat > nat] :
      ( ( ord_less_eq_nat @ ( size_size_list_nat @ Xs ) @ N )
     => ( ( listIn923761578nd_nat @ Xs @ F @ N )
        = ( F @ ( minus_minus_nat @ N @ ( size_size_list_nat @ Xs ) ) ) ) ) ).

% i_append_nth2
thf(fact_44_i__append__nth2,axiom,
    ! [Xs: list_a,N: nat,F: nat > a] :
      ( ( ord_less_eq_nat @ ( size_size_list_a @ Xs ) @ N )
     => ( ( listIn1312259492pend_a @ Xs @ F @ N )
        = ( F @ ( minus_minus_nat @ N @ ( size_size_list_a @ Xs ) ) ) ) ) ).

% i_append_nth2
thf(fact_45_nth__append,axiom,
    ! [N: nat,Xs: list_nat,Ys: list_nat] :
      ( ( ( ord_less_nat @ N @ ( size_size_list_nat @ Xs ) )
       => ( ( nth_nat @ ( append_nat @ Xs @ Ys ) @ N )
          = ( nth_nat @ Xs @ N ) ) )
      & ( ~ ( ord_less_nat @ N @ ( size_size_list_nat @ Xs ) )
       => ( ( nth_nat @ ( append_nat @ Xs @ Ys ) @ N )
          = ( nth_nat @ Ys @ ( minus_minus_nat @ N @ ( size_size_list_nat @ Xs ) ) ) ) ) ) ).

% nth_append
thf(fact_46_nth__append,axiom,
    ! [N: nat,Xs: list_a,Ys: list_a] :
      ( ( ( ord_less_nat @ N @ ( size_size_list_a @ Xs ) )
       => ( ( nth_a @ ( append_a @ Xs @ Ys ) @ N )
          = ( nth_a @ Xs @ N ) ) )
      & ( ~ ( ord_less_nat @ N @ ( size_size_list_a @ Xs ) )
       => ( ( nth_a @ ( append_a @ Xs @ Ys ) @ N )
          = ( nth_a @ Ys @ ( minus_minus_nat @ N @ ( size_size_list_a @ Xs ) ) ) ) ) ) ).

% nth_append
thf(fact_47_nth__list__update__eq,axiom,
    ! [I3: nat,Xs: list_nat,X2: nat] :
      ( ( ord_less_nat @ I3 @ ( size_size_list_nat @ Xs ) )
     => ( ( nth_nat @ ( list_update_nat @ Xs @ I3 @ X2 ) @ I3 )
        = X2 ) ) ).

% nth_list_update_eq
thf(fact_48_nth__list__update__eq,axiom,
    ! [I3: nat,Xs: list_a,X2: a] :
      ( ( ord_less_nat @ I3 @ ( size_size_list_a @ Xs ) )
     => ( ( nth_a @ ( list_update_a @ Xs @ I3 @ X2 ) @ I3 )
        = X2 ) ) ).

% nth_list_update_eq
thf(fact_49_nth__butlast,axiom,
    ! [N: nat,Xs: list_nat] :
      ( ( ord_less_nat @ N @ ( size_size_list_nat @ ( butlast_nat @ Xs ) ) )
     => ( ( nth_nat @ ( butlast_nat @ Xs ) @ N )
        = ( nth_nat @ Xs @ N ) ) ) ).

% nth_butlast
thf(fact_50_nth__butlast,axiom,
    ! [N: nat,Xs: list_a] :
      ( ( ord_less_nat @ N @ ( size_size_list_a @ ( butlast_a @ Xs ) ) )
     => ( ( nth_a @ ( butlast_a @ Xs ) @ N )
        = ( nth_a @ Xs @ N ) ) ) ).

% nth_butlast
thf(fact_51_mem__Collect__eq,axiom,
    ! [A: a,P: a > $o] :
      ( ( member_a @ A @ ( collect_a @ P ) )
      = ( P @ A ) ) ).

% mem_Collect_eq
thf(fact_52_Collect__mem__eq,axiom,
    ! [A2: set_a] :
      ( ( collect_a
        @ ^ [X3: a] : ( member_a @ X3 @ A2 ) )
      = A2 ) ).

% Collect_mem_eq
thf(fact_53_append_Oassoc,axiom,
    ! [A: list_a,B: list_a,C: list_a] :
      ( ( append_a @ ( append_a @ A @ B ) @ C )
      = ( append_a @ A @ ( append_a @ B @ C ) ) ) ).

% append.assoc
thf(fact_54_append__assoc,axiom,
    ! [Xs: list_a,Ys: list_a,Zs: list_a] :
      ( ( append_a @ ( append_a @ Xs @ Ys ) @ Zs )
      = ( append_a @ Xs @ ( append_a @ Ys @ Zs ) ) ) ).

% append_assoc
thf(fact_55_append__same__eq,axiom,
    ! [Ys: list_a,Xs: list_a,Zs: list_a] :
      ( ( ( append_a @ Ys @ Xs )
        = ( append_a @ Zs @ Xs ) )
      = ( Ys = Zs ) ) ).

% append_same_eq
thf(fact_56_same__append__eq,axiom,
    ! [Xs: list_a,Ys: list_a,Zs: list_a] :
      ( ( ( append_a @ Xs @ Ys )
        = ( append_a @ Xs @ Zs ) )
      = ( Ys = Zs ) ) ).

% same_append_eq
thf(fact_57_list__update__overwrite,axiom,
    ! [Xs: list_a,I3: nat,X2: a,Y2: a] :
      ( ( list_update_a @ ( list_update_a @ Xs @ I3 @ X2 ) @ I3 @ Y2 )
      = ( list_update_a @ Xs @ I3 @ Y2 ) ) ).

% list_update_overwrite
thf(fact_58_diff__diff__cancel,axiom,
    ! [I3: nat,N: nat] :
      ( ( ord_less_eq_nat @ I3 @ N )
     => ( ( minus_minus_nat @ N @ ( minus_minus_nat @ N @ I3 ) )
        = I3 ) ) ).

% diff_diff_cancel
thf(fact_59_append__eq__append__conv,axiom,
    ! [Xs: list_nat,Ys: list_nat,Us: list_nat,Vs: list_nat] :
      ( ( ( ( size_size_list_nat @ Xs )
          = ( size_size_list_nat @ Ys ) )
        | ( ( size_size_list_nat @ Us )
          = ( size_size_list_nat @ Vs ) ) )
     => ( ( ( append_nat @ Xs @ Us )
          = ( append_nat @ Ys @ Vs ) )
        = ( ( Xs = Ys )
          & ( Us = Vs ) ) ) ) ).

% append_eq_append_conv
thf(fact_60_append__eq__append__conv,axiom,
    ! [Xs: list_a,Ys: list_a,Us: list_a,Vs: list_a] :
      ( ( ( ( size_size_list_a @ Xs )
          = ( size_size_list_a @ Ys ) )
        | ( ( size_size_list_a @ Us )
          = ( size_size_list_a @ Vs ) ) )
     => ( ( ( append_a @ Xs @ Us )
          = ( append_a @ Ys @ Vs ) )
        = ( ( Xs = Ys )
          & ( Us = Vs ) ) ) ) ).

% append_eq_append_conv
thf(fact_61_length__list__update,axiom,
    ! [Xs: list_nat,I3: nat,X2: nat] :
      ( ( size_size_list_nat @ ( list_update_nat @ Xs @ I3 @ X2 ) )
      = ( size_size_list_nat @ Xs ) ) ).

% length_list_update
thf(fact_62_length__list__update,axiom,
    ! [Xs: list_a,I3: nat,X2: a] :
      ( ( size_size_list_a @ ( list_update_a @ Xs @ I3 @ X2 ) )
      = ( size_size_list_a @ Xs ) ) ).

% length_list_update
thf(fact_63_list__update__id,axiom,
    ! [Xs: list_nat,I3: nat] :
      ( ( list_update_nat @ Xs @ I3 @ ( nth_nat @ Xs @ I3 ) )
      = Xs ) ).

% list_update_id
thf(fact_64_list__update__id,axiom,
    ! [Xs: list_a,I3: nat] :
      ( ( list_update_a @ Xs @ I3 @ ( nth_a @ Xs @ I3 ) )
      = Xs ) ).

% list_update_id
thf(fact_65_nth__list__update__neq,axiom,
    ! [I3: nat,J: nat,Xs: list_nat,X2: nat] :
      ( ( I3 != J )
     => ( ( nth_nat @ ( list_update_nat @ Xs @ I3 @ X2 ) @ J )
        = ( nth_nat @ Xs @ J ) ) ) ).

% nth_list_update_neq
thf(fact_66_nth__list__update__neq,axiom,
    ! [I3: nat,J: nat,Xs: list_a,X2: a] :
      ( ( I3 != J )
     => ( ( nth_a @ ( list_update_a @ Xs @ I3 @ X2 ) @ J )
        = ( nth_a @ Xs @ J ) ) ) ).

% nth_list_update_neq
thf(fact_67_list__ex__append,axiom,
    ! [P: a > $o,Xs: list_a,Ys: list_a] :
      ( ( list_ex_a @ P @ ( append_a @ Xs @ Ys ) )
      = ( ( list_ex_a @ P @ Xs )
        | ( list_ex_a @ P @ Ys ) ) ) ).

% list_ex_append
thf(fact_68_i__append__assoc,axiom,
    ! [Xs: list_a,Ys: list_a,F: nat > a] :
      ( ( listIn1312259492pend_a @ Xs @ ( listIn1312259492pend_a @ Ys @ F ) )
      = ( listIn1312259492pend_a @ ( append_a @ Xs @ Ys ) @ F ) ) ).

% i_append_assoc
thf(fact_69_list__update__beyond,axiom,
    ! [Xs: list_nat,I3: nat,X2: nat] :
      ( ( ord_less_eq_nat @ ( size_size_list_nat @ Xs ) @ I3 )
     => ( ( list_update_nat @ Xs @ I3 @ X2 )
        = Xs ) ) ).

% list_update_beyond
thf(fact_70_list__update__beyond,axiom,
    ! [Xs: list_a,I3: nat,X2: a] :
      ( ( ord_less_eq_nat @ ( size_size_list_a @ Xs ) @ I3 )
     => ( ( list_update_a @ Xs @ I3 @ X2 )
        = Xs ) ) ).

% list_update_beyond
thf(fact_71_le__refl,axiom,
    ! [N: nat] : ( ord_less_eq_nat @ N @ N ) ).

% le_refl
thf(fact_72_le__trans,axiom,
    ! [I3: nat,J: nat,K: nat] :
      ( ( ord_less_eq_nat @ I3 @ J )
     => ( ( ord_less_eq_nat @ J @ K )
       => ( ord_less_eq_nat @ I3 @ K ) ) ) ).

% le_trans
thf(fact_73_eq__imp__le,axiom,
    ! [M: nat,N: nat] :
      ( ( M = N )
     => ( ord_less_eq_nat @ M @ N ) ) ).

% eq_imp_le
thf(fact_74_le__antisym,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less_eq_nat @ M @ N )
     => ( ( ord_less_eq_nat @ N @ M )
       => ( M = N ) ) ) ).

% le_antisym
thf(fact_75_nat__le__linear,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less_eq_nat @ M @ N )
      | ( ord_less_eq_nat @ N @ M ) ) ).

% nat_le_linear
thf(fact_76_list__update__swap,axiom,
    ! [I3: nat,I4: nat,Xs: list_a,X2: a,X4: a] :
      ( ( I3 != I4 )
     => ( ( list_update_a @ ( list_update_a @ Xs @ I3 @ X2 ) @ I4 @ X4 )
        = ( list_update_a @ ( list_update_a @ Xs @ I4 @ X4 ) @ I3 @ X2 ) ) ) ).

% list_update_swap
thf(fact_77_append__eq__appendI,axiom,
    ! [Xs: list_a,Xs1: list_a,Zs: list_a,Ys: list_a,Us: list_a] :
      ( ( ( append_a @ Xs @ Xs1 )
        = Zs )
     => ( ( Ys
          = ( append_a @ Xs1 @ Us ) )
       => ( ( append_a @ Xs @ Ys )
          = ( append_a @ Zs @ Us ) ) ) ) ).

% append_eq_appendI
thf(fact_78_Nat_Oex__has__greatest__nat,axiom,
    ! [P: nat > $o,K: nat,B: nat] :
      ( ( P @ K )
     => ( ! [Y3: nat] :
            ( ( P @ Y3 )
           => ( ord_less_eq_nat @ Y3 @ B ) )
       => ? [X5: nat] :
            ( ( P @ X5 )
            & ! [Y4: nat] :
                ( ( P @ Y4 )
               => ( ord_less_eq_nat @ Y4 @ X5 ) ) ) ) ) ).

% Nat.ex_has_greatest_nat
thf(fact_79_append__eq__append__conv2,axiom,
    ! [Xs: list_a,Ys: list_a,Zs: list_a,Ts: list_a] :
      ( ( ( append_a @ Xs @ Ys )
        = ( append_a @ Zs @ Ts ) )
      = ( ? [Us2: list_a] :
            ( ( ( Xs
                = ( append_a @ Zs @ Us2 ) )
              & ( ( append_a @ Us2 @ Ys )
                = Ts ) )
            | ( ( ( append_a @ Xs @ Us2 )
                = Zs )
              & ( Ys
                = ( append_a @ Us2 @ Ts ) ) ) ) ) ) ).

% append_eq_append_conv2
thf(fact_80_list__strict__asc__trans__le,axiom,
    ! [Xs: list_nat] :
      ( ( list_strict_asc_nat @ Xs )
     => ! [J3: nat] :
          ( ( ord_less_nat @ J3 @ ( size_size_list_nat @ Xs ) )
         => ! [I5: nat] :
              ( ( ord_less_eq_nat @ I5 @ J3 )
             => ( ord_less_eq_nat @ ( nth_nat @ Xs @ I5 ) @ ( nth_nat @ Xs @ J3 ) ) ) ) ) ).

% list_strict_asc_trans_le
thf(fact_81_list__update__append1,axiom,
    ! [I3: nat,Xs: list_nat,Ys: list_nat,X2: nat] :
      ( ( ord_less_nat @ I3 @ ( size_size_list_nat @ Xs ) )
     => ( ( list_update_nat @ ( append_nat @ Xs @ Ys ) @ I3 @ X2 )
        = ( append_nat @ ( list_update_nat @ Xs @ I3 @ X2 ) @ Ys ) ) ) ).

% list_update_append1
thf(fact_82_list__update__append1,axiom,
    ! [I3: nat,Xs: list_a,Ys: list_a,X2: a] :
      ( ( ord_less_nat @ I3 @ ( size_size_list_a @ Xs ) )
     => ( ( list_update_a @ ( append_a @ Xs @ Ys ) @ I3 @ X2 )
        = ( append_a @ ( list_update_a @ Xs @ I3 @ X2 ) @ Ys ) ) ) ).

% list_update_append1
thf(fact_83_nth__append2,axiom,
    ! [Xs: list_nat,N: nat,Ys: list_nat] :
      ( ( ord_less_eq_nat @ ( size_size_list_nat @ Xs ) @ N )
     => ( ( nth_nat @ ( append_nat @ Xs @ Ys ) @ N )
        = ( nth_nat @ Ys @ ( minus_minus_nat @ N @ ( size_size_list_nat @ Xs ) ) ) ) ) ).

% nth_append2
thf(fact_84_nth__append2,axiom,
    ! [Xs: list_a,N: nat,Ys: list_a] :
      ( ( ord_less_eq_nat @ ( size_size_list_a @ Xs ) @ N )
     => ( ( nth_a @ ( append_a @ Xs @ Ys ) @ N )
        = ( nth_a @ Ys @ ( minus_minus_nat @ N @ ( size_size_list_a @ Xs ) ) ) ) ) ).

% nth_append2
thf(fact_85_ge__less__neq__conv,axiom,
    ( ord_less_eq_nat
    = ( ^ [A3: nat,N3: nat] :
        ! [X3: nat] :
          ( ( ord_less_nat @ X3 @ A3 )
         => ( N3 != X3 ) ) ) ) ).

% ge_less_neq_conv
thf(fact_86_less__ge__neq__conv,axiom,
    ( ord_less_nat
    = ( ^ [N3: nat,A3: nat] :
        ! [X3: nat] :
          ( ( ord_less_eq_nat @ A3 @ X3 )
         => ( N3 != X3 ) ) ) ) ).

% less_ge_neq_conv
thf(fact_87_greater__le__neq__conv,axiom,
    ( ord_less_nat
    = ( ^ [A3: nat,N3: nat] :
        ! [X3: nat] :
          ( ( ord_less_eq_nat @ X3 @ A3 )
         => ( N3 != X3 ) ) ) ) ).

% greater_le_neq_conv
thf(fact_88_le__greater__neq__conv,axiom,
    ( ord_less_eq_nat
    = ( ^ [N3: nat,A3: nat] :
        ! [X3: nat] :
          ( ( ord_less_nat @ A3 @ X3 )
         => ( N3 != X3 ) ) ) ) ).

% le_greater_neq_conv
thf(fact_89_nat__less__le,axiom,
    ( ord_less_nat
    = ( ^ [M3: nat,N3: nat] :
          ( ( ord_less_eq_nat @ M3 @ N3 )
          & ( M3 != N3 ) ) ) ) ).

% nat_less_le
thf(fact_90_less__imp__le__nat,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less_nat @ M @ N )
     => ( ord_less_eq_nat @ M @ N ) ) ).

% less_imp_le_nat
thf(fact_91_le__eq__less__or__eq,axiom,
    ( ord_less_eq_nat
    = ( ^ [M3: nat,N3: nat] :
          ( ( ord_less_nat @ M3 @ N3 )
          | ( M3 = N3 ) ) ) ) ).

% le_eq_less_or_eq
thf(fact_92_less__or__eq__imp__le,axiom,
    ! [M: nat,N: nat] :
      ( ( ( ord_less_nat @ M @ N )
        | ( M = N ) )
     => ( ord_less_eq_nat @ M @ N ) ) ).

% less_or_eq_imp_le
thf(fact_93_le__neq__implies__less,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less_eq_nat @ M @ N )
     => ( ( M != N )
       => ( ord_less_nat @ M @ N ) ) ) ).

% le_neq_implies_less
thf(fact_94_less__mono__imp__le__mono,axiom,
    ! [F: nat > nat,I3: nat,J: nat] :
      ( ! [I: nat,J4: nat] :
          ( ( ord_less_nat @ I @ J4 )
         => ( ord_less_nat @ ( F @ I ) @ ( F @ J4 ) ) )
     => ( ( ord_less_eq_nat @ I3 @ J )
       => ( ord_less_eq_nat @ ( F @ I3 ) @ ( F @ J ) ) ) ) ).

% less_mono_imp_le_mono
thf(fact_95_eq__diff__iff,axiom,
    ! [K: nat,M: nat,N: nat] :
      ( ( ord_less_eq_nat @ K @ M )
     => ( ( ord_less_eq_nat @ K @ N )
       => ( ( ( minus_minus_nat @ M @ K )
            = ( minus_minus_nat @ N @ K ) )
          = ( M = N ) ) ) ) ).

% eq_diff_iff
thf(fact_96_le__diff__iff,axiom,
    ! [K: nat,M: nat,N: nat] :
      ( ( ord_less_eq_nat @ K @ M )
     => ( ( ord_less_eq_nat @ K @ N )
       => ( ( ord_less_eq_nat @ ( minus_minus_nat @ M @ K ) @ ( minus_minus_nat @ N @ K ) )
          = ( ord_less_eq_nat @ M @ N ) ) ) ) ).

% le_diff_iff
thf(fact_97_Nat_Odiff__diff__eq,axiom,
    ! [K: nat,M: nat,N: nat] :
      ( ( ord_less_eq_nat @ K @ M )
     => ( ( ord_less_eq_nat @ K @ N )
       => ( ( minus_minus_nat @ ( minus_minus_nat @ M @ K ) @ ( minus_minus_nat @ N @ K ) )
          = ( minus_minus_nat @ M @ N ) ) ) ) ).

% Nat.diff_diff_eq
thf(fact_98_diff__le__mono,axiom,
    ! [M: nat,N: nat,L: nat] :
      ( ( ord_less_eq_nat @ M @ N )
     => ( ord_less_eq_nat @ ( minus_minus_nat @ M @ L ) @ ( minus_minus_nat @ N @ L ) ) ) ).

% diff_le_mono
thf(fact_99_diff__le__self,axiom,
    ! [M: nat,N: nat] : ( ord_less_eq_nat @ ( minus_minus_nat @ M @ N ) @ M ) ).

% diff_le_self
thf(fact_100_le__diff__iff_H,axiom,
    ! [A: nat,C: nat,B: nat] :
      ( ( ord_less_eq_nat @ A @ C )
     => ( ( ord_less_eq_nat @ B @ C )
       => ( ( ord_less_eq_nat @ ( minus_minus_nat @ C @ A ) @ ( minus_minus_nat @ C @ B ) )
          = ( ord_less_eq_nat @ B @ A ) ) ) ) ).

% le_diff_iff'
thf(fact_101_diff__le__mono2,axiom,
    ! [M: nat,N: nat,L: nat] :
      ( ( ord_less_eq_nat @ M @ N )
     => ( ord_less_eq_nat @ ( minus_minus_nat @ L @ N ) @ ( minus_minus_nat @ L @ M ) ) ) ).

% diff_le_mono2
thf(fact_102_le__diff__swap,axiom,
    ! [I3: nat,K: nat,J: nat] :
      ( ( ord_less_eq_nat @ I3 @ K )
     => ( ( ord_less_eq_nat @ J @ K )
       => ( ( ord_less_eq_nat @ ( minus_minus_nat @ K @ J ) @ I3 )
          = ( ord_less_eq_nat @ ( minus_minus_nat @ K @ I3 ) @ J ) ) ) ) ).

% le_diff_swap
thf(fact_103_le__diff__imp__le,axiom,
    ! [I3: nat,J: nat,M: nat] :
      ( ( ord_less_eq_nat @ I3 @ ( minus_minus_nat @ J @ M ) )
     => ( ord_less_eq_nat @ I3 @ J ) ) ).

% le_diff_imp_le
thf(fact_104_le__imp__diff__le,axiom,
    ! [J: nat,K: nat,N: nat] :
      ( ( ord_less_eq_nat @ J @ K )
     => ( ord_less_eq_nat @ ( minus_minus_nat @ J @ N ) @ K ) ) ).

% le_imp_diff_le
thf(fact_105_eq__diff__left__iff,axiom,
    ! [M: nat,K: nat,N: nat] :
      ( ( ord_less_eq_nat @ M @ K )
     => ( ( ord_less_eq_nat @ N @ K )
       => ( ( ( minus_minus_nat @ K @ M )
            = ( minus_minus_nat @ K @ N ) )
          = ( M = N ) ) ) ) ).

% eq_diff_left_iff
thf(fact_106_le__diff__le__imp__le,axiom,
    ! [I3: nat,J: nat,M: nat,N: nat] :
      ( ( ord_less_eq_nat @ I3 @ ( minus_minus_nat @ J @ M ) )
     => ( ( ord_less_eq_nat @ N @ M )
       => ( ord_less_eq_nat @ I3 @ ( minus_minus_nat @ J @ N ) ) ) ) ).

% le_diff_le_imp_le
thf(fact_107_nat__diff__left__cancel__le2,axiom,
    ! [K: nat,M: nat,N: nat] :
      ( ( ord_less_eq_nat @ ( minus_minus_nat @ K @ M ) @ ( minus_minus_nat @ K @ N ) )
     => ( ( ord_less_eq_nat @ N @ K )
       => ( ord_less_eq_nat @ N @ M ) ) ) ).

% nat_diff_left_cancel_le2
thf(fact_108_nat__diff__right__cancel__le2,axiom,
    ! [M: nat,K: nat,N: nat] :
      ( ( ord_less_eq_nat @ ( minus_minus_nat @ M @ K ) @ ( minus_minus_nat @ N @ K ) )
     => ( ( ord_less_eq_nat @ K @ N )
       => ( ord_less_eq_nat @ M @ N ) ) ) ).

% nat_diff_right_cancel_le2
thf(fact_109_list__update__append,axiom,
    ! [N: nat,Xs: list_nat,Ys: list_nat,X2: nat] :
      ( ( ( ord_less_nat @ N @ ( size_size_list_nat @ Xs ) )
       => ( ( list_update_nat @ ( append_nat @ Xs @ Ys ) @ N @ X2 )
          = ( append_nat @ ( list_update_nat @ Xs @ N @ X2 ) @ Ys ) ) )
      & ( ~ ( ord_less_nat @ N @ ( size_size_list_nat @ Xs ) )
       => ( ( list_update_nat @ ( append_nat @ Xs @ Ys ) @ N @ X2 )
          = ( append_nat @ Xs @ ( list_update_nat @ Ys @ ( minus_minus_nat @ N @ ( size_size_list_nat @ Xs ) ) @ X2 ) ) ) ) ) ).

% list_update_append
thf(fact_110_list__update__append,axiom,
    ! [N: nat,Xs: list_a,Ys: list_a,X2: a] :
      ( ( ( ord_less_nat @ N @ ( size_size_list_a @ Xs ) )
       => ( ( list_update_a @ ( append_a @ Xs @ Ys ) @ N @ X2 )
          = ( append_a @ ( list_update_a @ Xs @ N @ X2 ) @ Ys ) ) )
      & ( ~ ( ord_less_nat @ N @ ( size_size_list_a @ Xs ) )
       => ( ( list_update_a @ ( append_a @ Xs @ Ys ) @ N @ X2 )
          = ( append_a @ Xs @ ( list_update_a @ Ys @ ( minus_minus_nat @ N @ ( size_size_list_a @ Xs ) ) @ X2 ) ) ) ) ) ).

% list_update_append
thf(fact_111_nth__append1,axiom,
    ! [N: nat,Xs: list_nat,Ys: list_nat] :
      ( ( ord_less_nat @ N @ ( size_size_list_nat @ Xs ) )
     => ( ( nth_nat @ ( append_nat @ Xs @ Ys ) @ N )
        = ( nth_nat @ Xs @ N ) ) ) ).

% nth_append1
thf(fact_112_nth__append1,axiom,
    ! [N: nat,Xs: list_a,Ys: list_a] :
      ( ( ord_less_nat @ N @ ( size_size_list_a @ Xs ) )
     => ( ( nth_a @ ( append_a @ Xs @ Ys ) @ N )
        = ( nth_a @ Xs @ N ) ) ) ).

% nth_append1
thf(fact_113_less__diff__iff,axiom,
    ! [K: nat,M: nat,N: nat] :
      ( ( ord_less_eq_nat @ K @ M )
     => ( ( ord_less_eq_nat @ K @ N )
       => ( ( ord_less_nat @ ( minus_minus_nat @ M @ K ) @ ( minus_minus_nat @ N @ K ) )
          = ( ord_less_nat @ M @ N ) ) ) ) ).

% less_diff_iff
thf(fact_114_diff__less__mono,axiom,
    ! [A: nat,B: nat,C: nat] :
      ( ( ord_less_nat @ A @ B )
     => ( ( ord_less_eq_nat @ C @ A )
       => ( ord_less_nat @ ( minus_minus_nat @ A @ C ) @ ( minus_minus_nat @ B @ C ) ) ) ) ).

% diff_less_mono
thf(fact_115_less__diff__le__imp__less,axiom,
    ! [I3: nat,J: nat,M: nat,N: nat] :
      ( ( ord_less_nat @ I3 @ ( minus_minus_nat @ J @ M ) )
     => ( ( ord_less_eq_nat @ N @ M )
       => ( ord_less_nat @ I3 @ ( minus_minus_nat @ J @ N ) ) ) ) ).

% less_diff_le_imp_less
thf(fact_116_nat__diff__left__cancel__le1,axiom,
    ! [K: nat,M: nat,N: nat] :
      ( ( ord_less_eq_nat @ ( minus_minus_nat @ K @ M ) @ ( minus_minus_nat @ K @ N ) )
     => ( ( ord_less_nat @ M @ K )
       => ( ord_less_eq_nat @ N @ M ) ) ) ).

% nat_diff_left_cancel_le1
thf(fact_117_nat__diff__right__cancel__le1,axiom,
    ! [M: nat,K: nat,N: nat] :
      ( ( ord_less_eq_nat @ ( minus_minus_nat @ M @ K ) @ ( minus_minus_nat @ N @ K ) )
     => ( ( ord_less_nat @ K @ M )
       => ( ord_less_eq_nat @ M @ N ) ) ) ).

% nat_diff_right_cancel_le1
thf(fact_118_nth__list__update,axiom,
    ! [I3: nat,Xs: list_nat,J: nat,X2: nat] :
      ( ( ord_less_nat @ I3 @ ( size_size_list_nat @ Xs ) )
     => ( ( ( I3 = J )
         => ( ( nth_nat @ ( list_update_nat @ Xs @ I3 @ X2 ) @ J )
            = X2 ) )
        & ( ( I3 != J )
         => ( ( nth_nat @ ( list_update_nat @ Xs @ I3 @ X2 ) @ J )
            = ( nth_nat @ Xs @ J ) ) ) ) ) ).

% nth_list_update
thf(fact_119_nth__list__update,axiom,
    ! [I3: nat,Xs: list_a,J: nat,X2: a] :
      ( ( ord_less_nat @ I3 @ ( size_size_list_a @ Xs ) )
     => ( ( ( I3 = J )
         => ( ( nth_a @ ( list_update_a @ Xs @ I3 @ X2 ) @ J )
            = X2 ) )
        & ( ( I3 != J )
         => ( ( nth_a @ ( list_update_a @ Xs @ I3 @ X2 ) @ J )
            = ( nth_a @ Xs @ J ) ) ) ) ) ).

% nth_list_update
thf(fact_120_list__update__same__conv,axiom,
    ! [I3: nat,Xs: list_nat,X2: nat] :
      ( ( ord_less_nat @ I3 @ ( size_size_list_nat @ Xs ) )
     => ( ( ( list_update_nat @ Xs @ I3 @ X2 )
          = Xs )
        = ( ( nth_nat @ Xs @ I3 )
          = X2 ) ) ) ).

% list_update_same_conv
thf(fact_121_list__update__same__conv,axiom,
    ! [I3: nat,Xs: list_a,X2: a] :
      ( ( ord_less_nat @ I3 @ ( size_size_list_a @ Xs ) )
     => ( ( ( list_update_a @ Xs @ I3 @ X2 )
          = Xs )
        = ( ( nth_a @ Xs @ I3 )
          = X2 ) ) ) ).

% list_update_same_conv
thf(fact_122_diff__right__commute,axiom,
    ! [A: nat,C: nat,B: nat] :
      ( ( minus_minus_nat @ ( minus_minus_nat @ A @ C ) @ B )
      = ( minus_minus_nat @ ( minus_minus_nat @ A @ B ) @ C ) ) ).

% diff_right_commute
thf(fact_123_list__desc__trans__le,axiom,
    ( list_desc_nat
    = ( ^ [Xs2: list_nat] :
        ! [J2: nat] :
          ( ( ord_less_nat @ J2 @ ( size_size_list_nat @ Xs2 ) )
         => ! [I2: nat] :
              ( ( ord_less_eq_nat @ I2 @ J2 )
             => ( ord_less_eq_nat @ ( nth_nat @ Xs2 @ J2 ) @ ( nth_nat @ Xs2 @ I2 ) ) ) ) ) ) ).

% list_desc_trans_le
thf(fact_124_list__asc__trans__le,axiom,
    ( list_asc_nat
    = ( ^ [Xs2: list_nat] :
        ! [J2: nat] :
          ( ( ord_less_nat @ J2 @ ( size_size_list_nat @ Xs2 ) )
         => ! [I2: nat] :
              ( ( ord_less_eq_nat @ I2 @ J2 )
             => ( ord_less_eq_nat @ ( nth_nat @ Xs2 @ I2 ) @ ( nth_nat @ Xs2 @ J2 ) ) ) ) ) ) ).

% list_asc_trans_le
thf(fact_125_list__desc__trans,axiom,
    ( list_desc_nat
    = ( ^ [Xs2: list_nat] :
        ! [J2: nat] :
          ( ( ord_less_nat @ J2 @ ( size_size_list_nat @ Xs2 ) )
         => ! [I2: nat] :
              ( ( ord_less_nat @ I2 @ J2 )
             => ( ord_less_eq_nat @ ( nth_nat @ Xs2 @ J2 ) @ ( nth_nat @ Xs2 @ I2 ) ) ) ) ) ) ).

% list_desc_trans
thf(fact_126_list__asc__trans,axiom,
    ( list_asc_nat
    = ( ^ [Xs2: list_nat] :
        ! [J2: nat] :
          ( ( ord_less_nat @ J2 @ ( size_size_list_nat @ Xs2 ) )
         => ! [I2: nat] :
              ( ( ord_less_nat @ I2 @ J2 )
             => ( ord_less_eq_nat @ ( nth_nat @ Xs2 @ I2 ) @ ( nth_nat @ Xs2 @ J2 ) ) ) ) ) ) ).

% list_asc_trans
thf(fact_127_order__refl,axiom,
    ! [X2: nat] : ( ord_less_eq_nat @ X2 @ X2 ) ).

% order_refl
thf(fact_128_nat__descend__induct,axiom,
    ! [N: nat,P: nat > $o,M: nat] :
      ( ! [K2: nat] :
          ( ( ord_less_nat @ N @ K2 )
         => ( P @ K2 ) )
     => ( ! [K2: nat] :
            ( ( ord_less_eq_nat @ K2 @ N )
           => ( ! [I5: nat] :
                  ( ( ord_less_nat @ K2 @ I5 )
                 => ( P @ I5 ) )
             => ( P @ K2 ) ) )
       => ( P @ M ) ) ) ).

% nat_descend_induct
thf(fact_129_minf_I8_J,axiom,
    ! [T: nat] :
    ? [Z2: nat] :
    ! [X6: nat] :
      ( ( ord_less_nat @ X6 @ Z2 )
     => ~ ( ord_less_eq_nat @ T @ X6 ) ) ).

% minf(8)
thf(fact_130_order__subst1,axiom,
    ! [A: nat,F: nat > nat,B: nat,C: nat] :
      ( ( ord_less_eq_nat @ A @ ( F @ B ) )
     => ( ( ord_less_eq_nat @ B @ C )
       => ( ! [X5: nat,Y3: nat] :
              ( ( ord_less_eq_nat @ X5 @ Y3 )
             => ( ord_less_eq_nat @ ( F @ X5 ) @ ( F @ Y3 ) ) )
         => ( ord_less_eq_nat @ A @ ( F @ C ) ) ) ) ) ).

% order_subst1
thf(fact_131_order__subst2,axiom,
    ! [A: nat,B: nat,F: nat > nat,C: nat] :
      ( ( ord_less_eq_nat @ A @ B )
     => ( ( ord_less_eq_nat @ ( F @ B ) @ C )
       => ( ! [X5: nat,Y3: nat] :
              ( ( ord_less_eq_nat @ X5 @ Y3 )
             => ( ord_less_eq_nat @ ( F @ X5 ) @ ( F @ Y3 ) ) )
         => ( ord_less_eq_nat @ ( F @ A ) @ C ) ) ) ) ).

% order_subst2
thf(fact_132_ord__eq__le__subst,axiom,
    ! [A: nat,F: nat > nat,B: nat,C: nat] :
      ( ( A
        = ( F @ B ) )
     => ( ( ord_less_eq_nat @ B @ C )
       => ( ! [X5: nat,Y3: nat] :
              ( ( ord_less_eq_nat @ X5 @ Y3 )
             => ( ord_less_eq_nat @ ( F @ X5 ) @ ( F @ Y3 ) ) )
         => ( ord_less_eq_nat @ A @ ( F @ C ) ) ) ) ) ).

% ord_eq_le_subst
thf(fact_133_ord__le__eq__subst,axiom,
    ! [A: nat,B: nat,F: nat > nat,C: nat] :
      ( ( ord_less_eq_nat @ A @ B )
     => ( ( ( F @ B )
          = C )
       => ( ! [X5: nat,Y3: nat] :
              ( ( ord_less_eq_nat @ X5 @ Y3 )
             => ( ord_less_eq_nat @ ( F @ X5 ) @ ( F @ Y3 ) ) )
         => ( ord_less_eq_nat @ ( F @ A ) @ C ) ) ) ) ).

% ord_le_eq_subst
thf(fact_134_eq__iff,axiom,
    ( ( ^ [Y: nat,Z: nat] : ( Y = Z ) )
    = ( ^ [X3: nat,Y5: nat] :
          ( ( ord_less_eq_nat @ X3 @ Y5 )
          & ( ord_less_eq_nat @ Y5 @ X3 ) ) ) ) ).

% eq_iff
thf(fact_135_antisym,axiom,
    ! [X2: nat,Y2: nat] :
      ( ( ord_less_eq_nat @ X2 @ Y2 )
     => ( ( ord_less_eq_nat @ Y2 @ X2 )
       => ( X2 = Y2 ) ) ) ).

% antisym
thf(fact_136_linear,axiom,
    ! [X2: nat,Y2: nat] :
      ( ( ord_less_eq_nat @ X2 @ Y2 )
      | ( ord_less_eq_nat @ Y2 @ X2 ) ) ).

% linear
thf(fact_137_eq__refl,axiom,
    ! [X2: nat,Y2: nat] :
      ( ( X2 = Y2 )
     => ( ord_less_eq_nat @ X2 @ Y2 ) ) ).

% eq_refl
thf(fact_138_le__cases,axiom,
    ! [X2: nat,Y2: nat] :
      ( ~ ( ord_less_eq_nat @ X2 @ Y2 )
     => ( ord_less_eq_nat @ Y2 @ X2 ) ) ).

% le_cases
thf(fact_139_order_Otrans,axiom,
    ! [A: nat,B: nat,C: nat] :
      ( ( ord_less_eq_nat @ A @ B )
     => ( ( ord_less_eq_nat @ B @ C )
       => ( ord_less_eq_nat @ A @ C ) ) ) ).

% order.trans
thf(fact_140_le__cases3,axiom,
    ! [X2: nat,Y2: nat,Z3: nat] :
      ( ( ( ord_less_eq_nat @ X2 @ Y2 )
       => ~ ( ord_less_eq_nat @ Y2 @ Z3 ) )
     => ( ( ( ord_less_eq_nat @ Y2 @ X2 )
         => ~ ( ord_less_eq_nat @ X2 @ Z3 ) )
       => ( ( ( ord_less_eq_nat @ X2 @ Z3 )
           => ~ ( ord_less_eq_nat @ Z3 @ Y2 ) )
         => ( ( ( ord_less_eq_nat @ Z3 @ Y2 )
             => ~ ( ord_less_eq_nat @ Y2 @ X2 ) )
           => ( ( ( ord_less_eq_nat @ Y2 @ Z3 )
               => ~ ( ord_less_eq_nat @ Z3 @ X2 ) )
             => ~ ( ( ord_less_eq_nat @ Z3 @ X2 )
                 => ~ ( ord_less_eq_nat @ X2 @ Y2 ) ) ) ) ) ) ) ).

% le_cases3
thf(fact_141_antisym__conv,axiom,
    ! [Y2: nat,X2: nat] :
      ( ( ord_less_eq_nat @ Y2 @ X2 )
     => ( ( ord_less_eq_nat @ X2 @ Y2 )
        = ( X2 = Y2 ) ) ) ).

% antisym_conv
thf(fact_142_order__class_Oorder_Oeq__iff,axiom,
    ( ( ^ [Y: nat,Z: nat] : ( Y = Z ) )
    = ( ^ [A3: nat,B2: nat] :
          ( ( ord_less_eq_nat @ A3 @ B2 )
          & ( ord_less_eq_nat @ B2 @ A3 ) ) ) ) ).

% order_class.order.eq_iff
thf(fact_143_ord__eq__le__trans,axiom,
    ! [A: nat,B: nat,C: nat] :
      ( ( A = B )
     => ( ( ord_less_eq_nat @ B @ C )
       => ( ord_less_eq_nat @ A @ C ) ) ) ).

% ord_eq_le_trans
thf(fact_144_ord__le__eq__trans,axiom,
    ! [A: nat,B: nat,C: nat] :
      ( ( ord_less_eq_nat @ A @ B )
     => ( ( B = C )
       => ( ord_less_eq_nat @ A @ C ) ) ) ).

% ord_le_eq_trans
thf(fact_145_order__class_Oorder_Oantisym,axiom,
    ! [A: nat,B: nat] :
      ( ( ord_less_eq_nat @ A @ B )
     => ( ( ord_less_eq_nat @ B @ A )
       => ( A = B ) ) ) ).

% order_class.order.antisym
thf(fact_146_order__trans,axiom,
    ! [X2: nat,Y2: nat,Z3: nat] :
      ( ( ord_less_eq_nat @ X2 @ Y2 )
     => ( ( ord_less_eq_nat @ Y2 @ Z3 )
       => ( ord_less_eq_nat @ X2 @ Z3 ) ) ) ).

% order_trans
thf(fact_147_dual__order_Orefl,axiom,
    ! [A: nat] : ( ord_less_eq_nat @ A @ A ) ).

% dual_order.refl
thf(fact_148_linorder__wlog,axiom,
    ! [P: nat > nat > $o,A: nat,B: nat] :
      ( ! [A4: nat,B3: nat] :
          ( ( ord_less_eq_nat @ A4 @ B3 )
         => ( P @ A4 @ B3 ) )
     => ( ! [A4: nat,B3: nat] :
            ( ( P @ B3 @ A4 )
           => ( P @ A4 @ B3 ) )
       => ( P @ A @ B ) ) ) ).

% linorder_wlog
thf(fact_149_dual__order_Otrans,axiom,
    ! [B: nat,A: nat,C: nat] :
      ( ( ord_less_eq_nat @ B @ A )
     => ( ( ord_less_eq_nat @ C @ B )
       => ( ord_less_eq_nat @ C @ A ) ) ) ).

% dual_order.trans
thf(fact_150_dual__order_Oeq__iff,axiom,
    ( ( ^ [Y: nat,Z: nat] : ( Y = Z ) )
    = ( ^ [A3: nat,B2: nat] :
          ( ( ord_less_eq_nat @ B2 @ A3 )
          & ( ord_less_eq_nat @ A3 @ B2 ) ) ) ) ).

% dual_order.eq_iff
thf(fact_151_dual__order_Oantisym,axiom,
    ! [B: nat,A: nat] :
      ( ( ord_less_eq_nat @ B @ A )
     => ( ( ord_less_eq_nat @ A @ B )
       => ( A = B ) ) ) ).

% dual_order.antisym
thf(fact_152_dual__order_Ostrict__implies__not__eq,axiom,
    ! [B: nat,A: nat] :
      ( ( ord_less_nat @ B @ A )
     => ( A != B ) ) ).

% dual_order.strict_implies_not_eq
thf(fact_153_order_Ostrict__implies__not__eq,axiom,
    ! [A: nat,B: nat] :
      ( ( ord_less_nat @ A @ B )
     => ( A != B ) ) ).

% order.strict_implies_not_eq
thf(fact_154_not__less__iff__gr__or__eq,axiom,
    ! [X2: nat,Y2: nat] :
      ( ( ~ ( ord_less_nat @ X2 @ Y2 ) )
      = ( ( ord_less_nat @ Y2 @ X2 )
        | ( X2 = Y2 ) ) ) ).

% not_less_iff_gr_or_eq
thf(fact_155_dual__order_Ostrict__trans,axiom,
    ! [B: nat,A: nat,C: nat] :
      ( ( ord_less_nat @ B @ A )
     => ( ( ord_less_nat @ C @ B )
       => ( ord_less_nat @ C @ A ) ) ) ).

% dual_order.strict_trans
thf(fact_156_linorder__less__wlog,axiom,
    ! [P: nat > nat > $o,A: nat,B: nat] :
      ( ! [A4: nat,B3: nat] :
          ( ( ord_less_nat @ A4 @ B3 )
         => ( P @ A4 @ B3 ) )
     => ( ! [A4: nat] : ( P @ A4 @ A4 )
       => ( ! [A4: nat,B3: nat] :
              ( ( P @ B3 @ A4 )
             => ( P @ A4 @ B3 ) )
         => ( P @ A @ B ) ) ) ) ).

% linorder_less_wlog
thf(fact_157_exists__least__iff,axiom,
    ( ( ^ [P3: nat > $o] :
        ? [X: nat] : ( P3 @ X ) )
    = ( ^ [P2: nat > $o] :
        ? [N3: nat] :
          ( ( P2 @ N3 )
          & ! [M3: nat] :
              ( ( ord_less_nat @ M3 @ N3 )
             => ~ ( P2 @ M3 ) ) ) ) ) ).

% exists_least_iff
thf(fact_158_less__imp__not__less,axiom,
    ! [X2: nat,Y2: nat] :
      ( ( ord_less_nat @ X2 @ Y2 )
     => ~ ( ord_less_nat @ Y2 @ X2 ) ) ).

% less_imp_not_less
thf(fact_159_order_Ostrict__trans,axiom,
    ! [A: nat,B: nat,C: nat] :
      ( ( ord_less_nat @ A @ B )
     => ( ( ord_less_nat @ B @ C )
       => ( ord_less_nat @ A @ C ) ) ) ).

% order.strict_trans
thf(fact_160_dual__order_Oirrefl,axiom,
    ! [A: nat] :
      ~ ( ord_less_nat @ A @ A ) ).

% dual_order.irrefl
thf(fact_161_linorder__cases,axiom,
    ! [X2: nat,Y2: nat] :
      ( ~ ( ord_less_nat @ X2 @ Y2 )
     => ( ( X2 != Y2 )
       => ( ord_less_nat @ Y2 @ X2 ) ) ) ).

% linorder_cases
thf(fact_162_less__imp__triv,axiom,
    ! [X2: nat,Y2: nat,P: $o] :
      ( ( ord_less_nat @ X2 @ Y2 )
     => ( ( ord_less_nat @ Y2 @ X2 )
       => P ) ) ).

% less_imp_triv
thf(fact_163_less__imp__not__eq2,axiom,
    ! [X2: nat,Y2: nat] :
      ( ( ord_less_nat @ X2 @ Y2 )
     => ( Y2 != X2 ) ) ).

% less_imp_not_eq2
thf(fact_164_antisym__conv3,axiom,
    ! [Y2: nat,X2: nat] :
      ( ~ ( ord_less_nat @ Y2 @ X2 )
     => ( ( ~ ( ord_less_nat @ X2 @ Y2 ) )
        = ( X2 = Y2 ) ) ) ).

% antisym_conv3
thf(fact_165_less__induct,axiom,
    ! [P: nat > $o,A: nat] :
      ( ! [X5: nat] :
          ( ! [Y4: nat] :
              ( ( ord_less_nat @ Y4 @ X5 )
             => ( P @ Y4 ) )
         => ( P @ X5 ) )
     => ( P @ A ) ) ).

% less_induct
thf(fact_166_less__not__sym,axiom,
    ! [X2: nat,Y2: nat] :
      ( ( ord_less_nat @ X2 @ Y2 )
     => ~ ( ord_less_nat @ Y2 @ X2 ) ) ).

% less_not_sym
thf(fact_167_less__imp__not__eq,axiom,
    ! [X2: nat,Y2: nat] :
      ( ( ord_less_nat @ X2 @ Y2 )
     => ( X2 != Y2 ) ) ).

% less_imp_not_eq
thf(fact_168_dual__order_Oasym,axiom,
    ! [B: nat,A: nat] :
      ( ( ord_less_nat @ B @ A )
     => ~ ( ord_less_nat @ A @ B ) ) ).

% dual_order.asym
thf(fact_169_ord__less__eq__trans,axiom,
    ! [A: nat,B: nat,C: nat] :
      ( ( ord_less_nat @ A @ B )
     => ( ( B = C )
       => ( ord_less_nat @ A @ C ) ) ) ).

% ord_less_eq_trans
thf(fact_170_ord__eq__less__trans,axiom,
    ! [A: nat,B: nat,C: nat] :
      ( ( A = B )
     => ( ( ord_less_nat @ B @ C )
       => ( ord_less_nat @ A @ C ) ) ) ).

% ord_eq_less_trans
thf(fact_171_less__irrefl,axiom,
    ! [X2: nat] :
      ~ ( ord_less_nat @ X2 @ X2 ) ).

% less_irrefl
thf(fact_172_less__linear,axiom,
    ! [X2: nat,Y2: nat] :
      ( ( ord_less_nat @ X2 @ Y2 )
      | ( X2 = Y2 )
      | ( ord_less_nat @ Y2 @ X2 ) ) ).

% less_linear
thf(fact_173_less__trans,axiom,
    ! [X2: nat,Y2: nat,Z3: nat] :
      ( ( ord_less_nat @ X2 @ Y2 )
     => ( ( ord_less_nat @ Y2 @ Z3 )
       => ( ord_less_nat @ X2 @ Z3 ) ) ) ).

% less_trans
thf(fact_174_less__asym_H,axiom,
    ! [A: nat,B: nat] :
      ( ( ord_less_nat @ A @ B )
     => ~ ( ord_less_nat @ B @ A ) ) ).

% less_asym'
thf(fact_175_less__asym,axiom,
    ! [X2: nat,Y2: nat] :
      ( ( ord_less_nat @ X2 @ Y2 )
     => ~ ( ord_less_nat @ Y2 @ X2 ) ) ).

% less_asym
thf(fact_176_less__imp__neq,axiom,
    ! [X2: nat,Y2: nat] :
      ( ( ord_less_nat @ X2 @ Y2 )
     => ( X2 != Y2 ) ) ).

% less_imp_neq
thf(fact_177_order_Oasym,axiom,
    ! [A: nat,B: nat] :
      ( ( ord_less_nat @ A @ B )
     => ~ ( ord_less_nat @ B @ A ) ) ).

% order.asym
thf(fact_178_neq__iff,axiom,
    ! [X2: nat,Y2: nat] :
      ( ( X2 != Y2 )
      = ( ( ord_less_nat @ X2 @ Y2 )
        | ( ord_less_nat @ Y2 @ X2 ) ) ) ).

% neq_iff
thf(fact_179_neqE,axiom,
    ! [X2: nat,Y2: nat] :
      ( ( X2 != Y2 )
     => ( ~ ( ord_less_nat @ X2 @ Y2 )
       => ( ord_less_nat @ Y2 @ X2 ) ) ) ).

% neqE
thf(fact_180_gt__ex,axiom,
    ! [X2: nat] :
    ? [X_1: nat] : ( ord_less_nat @ X2 @ X_1 ) ).

% gt_ex
thf(fact_181_order__less__subst2,axiom,
    ! [A: nat,B: nat,F: nat > nat,C: nat] :
      ( ( ord_less_nat @ A @ B )
     => ( ( ord_less_nat @ ( F @ B ) @ C )
       => ( ! [X5: nat,Y3: nat] :
              ( ( ord_less_nat @ X5 @ Y3 )
             => ( ord_less_nat @ ( F @ X5 ) @ ( F @ Y3 ) ) )
         => ( ord_less_nat @ ( F @ A ) @ C ) ) ) ) ).

% order_less_subst2
thf(fact_182_order__less__subst1,axiom,
    ! [A: nat,F: nat > nat,B: nat,C: nat] :
      ( ( ord_less_nat @ A @ ( F @ B ) )
     => ( ( ord_less_nat @ B @ C )
       => ( ! [X5: nat,Y3: nat] :
              ( ( ord_less_nat @ X5 @ Y3 )
             => ( ord_less_nat @ ( F @ X5 ) @ ( F @ Y3 ) ) )
         => ( ord_less_nat @ A @ ( F @ C ) ) ) ) ) ).

% order_less_subst1
thf(fact_183_ord__less__eq__subst,axiom,
    ! [A: nat,B: nat,F: nat > nat,C: nat] :
      ( ( ord_less_nat @ A @ B )
     => ( ( ( F @ B )
          = C )
       => ( ! [X5: nat,Y3: nat] :
              ( ( ord_less_nat @ X5 @ Y3 )
             => ( ord_less_nat @ ( F @ X5 ) @ ( F @ Y3 ) ) )
         => ( ord_less_nat @ ( F @ A ) @ C ) ) ) ) ).

% ord_less_eq_subst
thf(fact_184_ord__eq__less__subst,axiom,
    ! [A: nat,F: nat > nat,B: nat,C: nat] :
      ( ( A
        = ( F @ B ) )
     => ( ( ord_less_nat @ B @ C )
       => ( ! [X5: nat,Y3: nat] :
              ( ( ord_less_nat @ X5 @ Y3 )
             => ( ord_less_nat @ ( F @ X5 ) @ ( F @ Y3 ) ) )
         => ( ord_less_nat @ A @ ( F @ C ) ) ) ) ) ).

% ord_eq_less_subst
thf(fact_185_pinf_I1_J,axiom,
    ! [P: nat > $o,P4: nat > $o,Q: nat > $o,Q2: nat > $o] :
      ( ? [Z4: nat] :
        ! [X5: nat] :
          ( ( ord_less_nat @ Z4 @ X5 )
         => ( ( P @ X5 )
            = ( P4 @ X5 ) ) )
     => ( ? [Z4: nat] :
          ! [X5: nat] :
            ( ( ord_less_nat @ Z4 @ X5 )
           => ( ( Q @ X5 )
              = ( Q2 @ X5 ) ) )
       => ? [Z2: nat] :
          ! [X6: nat] :
            ( ( ord_less_nat @ Z2 @ X6 )
           => ( ( ( P @ X6 )
                & ( Q @ X6 ) )
              = ( ( P4 @ X6 )
                & ( Q2 @ X6 ) ) ) ) ) ) ).

% pinf(1)
thf(fact_186_pinf_I2_J,axiom,
    ! [P: nat > $o,P4: nat > $o,Q: nat > $o,Q2: nat > $o] :
      ( ? [Z4: nat] :
        ! [X5: nat] :
          ( ( ord_less_nat @ Z4 @ X5 )
         => ( ( P @ X5 )
            = ( P4 @ X5 ) ) )
     => ( ? [Z4: nat] :
          ! [X5: nat] :
            ( ( ord_less_nat @ Z4 @ X5 )
           => ( ( Q @ X5 )
              = ( Q2 @ X5 ) ) )
       => ? [Z2: nat] :
          ! [X6: nat] :
            ( ( ord_less_nat @ Z2 @ X6 )
           => ( ( ( P @ X6 )
                | ( Q @ X6 ) )
              = ( ( P4 @ X6 )
                | ( Q2 @ X6 ) ) ) ) ) ) ).

% pinf(2)
thf(fact_187_pinf_I3_J,axiom,
    ! [T: nat] :
    ? [Z2: nat] :
    ! [X6: nat] :
      ( ( ord_less_nat @ Z2 @ X6 )
     => ( X6 != T ) ) ).

% pinf(3)
thf(fact_188_pinf_I4_J,axiom,
    ! [T: nat] :
    ? [Z2: nat] :
    ! [X6: nat] :
      ( ( ord_less_nat @ Z2 @ X6 )
     => ( X6 != T ) ) ).

% pinf(4)
thf(fact_189_pinf_I5_J,axiom,
    ! [T: nat] :
    ? [Z2: nat] :
    ! [X6: nat] :
      ( ( ord_less_nat @ Z2 @ X6 )
     => ~ ( ord_less_nat @ X6 @ T ) ) ).

% pinf(5)
thf(fact_190_pinf_I7_J,axiom,
    ! [T: nat] :
    ? [Z2: nat] :
    ! [X6: nat] :
      ( ( ord_less_nat @ Z2 @ X6 )
     => ( ord_less_nat @ T @ X6 ) ) ).

% pinf(7)
thf(fact_191_minf_I1_J,axiom,
    ! [P: nat > $o,P4: nat > $o,Q: nat > $o,Q2: nat > $o] :
      ( ? [Z4: nat] :
        ! [X5: nat] :
          ( ( ord_less_nat @ X5 @ Z4 )
         => ( ( P @ X5 )
            = ( P4 @ X5 ) ) )
     => ( ? [Z4: nat] :
          ! [X5: nat] :
            ( ( ord_less_nat @ X5 @ Z4 )
           => ( ( Q @ X5 )
              = ( Q2 @ X5 ) ) )
       => ? [Z2: nat] :
          ! [X6: nat] :
            ( ( ord_less_nat @ X6 @ Z2 )
           => ( ( ( P @ X6 )
                & ( Q @ X6 ) )
              = ( ( P4 @ X6 )
                & ( Q2 @ X6 ) ) ) ) ) ) ).

% minf(1)
thf(fact_192_minf_I2_J,axiom,
    ! [P: nat > $o,P4: nat > $o,Q: nat > $o,Q2: nat > $o] :
      ( ? [Z4: nat] :
        ! [X5: nat] :
          ( ( ord_less_nat @ X5 @ Z4 )
         => ( ( P @ X5 )
            = ( P4 @ X5 ) ) )
     => ( ? [Z4: nat] :
          ! [X5: nat] :
            ( ( ord_less_nat @ X5 @ Z4 )
           => ( ( Q @ X5 )
              = ( Q2 @ X5 ) ) )
       => ? [Z2: nat] :
          ! [X6: nat] :
            ( ( ord_less_nat @ X6 @ Z2 )
           => ( ( ( P @ X6 )
                | ( Q @ X6 ) )
              = ( ( P4 @ X6 )
                | ( Q2 @ X6 ) ) ) ) ) ) ).

% minf(2)
thf(fact_193_minf_I3_J,axiom,
    ! [T: nat] :
    ? [Z2: nat] :
    ! [X6: nat] :
      ( ( ord_less_nat @ X6 @ Z2 )
     => ( X6 != T ) ) ).

% minf(3)
thf(fact_194_minf_I4_J,axiom,
    ! [T: nat] :
    ? [Z2: nat] :
    ! [X6: nat] :
      ( ( ord_less_nat @ X6 @ Z2 )
     => ( X6 != T ) ) ).

% minf(4)
thf(fact_195_minf_I5_J,axiom,
    ! [T: nat] :
    ? [Z2: nat] :
    ! [X6: nat] :
      ( ( ord_less_nat @ X6 @ Z2 )
     => ( ord_less_nat @ X6 @ T ) ) ).

% minf(5)
thf(fact_196_minf_I7_J,axiom,
    ! [T: nat] :
    ? [Z2: nat] :
    ! [X6: nat] :
      ( ( ord_less_nat @ X6 @ Z2 )
     => ~ ( ord_less_nat @ T @ X6 ) ) ).

% minf(7)
thf(fact_197_list__strict__asc__imp__list__asc,axiom,
    ! [Xs: list_nat] :
      ( ( list_strict_asc_nat @ Xs )
     => ( list_asc_nat @ Xs ) ) ).

% list_strict_asc_imp_list_asc
thf(fact_198_list__strict__desc__imp__list__desc,axiom,
    ! [Xs: list_nat] :
      ( ( list_strict_desc_nat @ Xs )
     => ( list_desc_nat @ Xs ) ) ).

% list_strict_desc_imp_list_desc
thf(fact_199_order_Onot__eq__order__implies__strict,axiom,
    ! [A: nat,B: nat] :
      ( ( A != B )
     => ( ( ord_less_eq_nat @ A @ B )
       => ( ord_less_nat @ A @ B ) ) ) ).

% order.not_eq_order_implies_strict
thf(fact_200_dual__order_Ostrict__implies__order,axiom,
    ! [B: nat,A: nat] :
      ( ( ord_less_nat @ B @ A )
     => ( ord_less_eq_nat @ B @ A ) ) ).

% dual_order.strict_implies_order
thf(fact_201_dual__order_Ostrict__iff__order,axiom,
    ( ord_less_nat
    = ( ^ [B2: nat,A3: nat] :
          ( ( ord_less_eq_nat @ B2 @ A3 )
          & ( A3 != B2 ) ) ) ) ).

% dual_order.strict_iff_order
thf(fact_202_dual__order_Oorder__iff__strict,axiom,
    ( ord_less_eq_nat
    = ( ^ [B2: nat,A3: nat] :
          ( ( ord_less_nat @ B2 @ A3 )
          | ( A3 = B2 ) ) ) ) ).

% dual_order.order_iff_strict
thf(fact_203_order_Ostrict__implies__order,axiom,
    ! [A: nat,B: nat] :
      ( ( ord_less_nat @ A @ B )
     => ( ord_less_eq_nat @ A @ B ) ) ).

% order.strict_implies_order
thf(fact_204_dual__order_Ostrict__trans2,axiom,
    ! [B: nat,A: nat,C: nat] :
      ( ( ord_less_nat @ B @ A )
     => ( ( ord_less_eq_nat @ C @ B )
       => ( ord_less_nat @ C @ A ) ) ) ).

% dual_order.strict_trans2
thf(fact_205_dual__order_Ostrict__trans1,axiom,
    ! [B: nat,A: nat,C: nat] :
      ( ( ord_less_eq_nat @ B @ A )
     => ( ( ord_less_nat @ C @ B )
       => ( ord_less_nat @ C @ A ) ) ) ).

% dual_order.strict_trans1
thf(fact_206_order_Ostrict__iff__order,axiom,
    ( ord_less_nat
    = ( ^ [A3: nat,B2: nat] :
          ( ( ord_less_eq_nat @ A3 @ B2 )
          & ( A3 != B2 ) ) ) ) ).

% order.strict_iff_order
thf(fact_207_order_Oorder__iff__strict,axiom,
    ( ord_less_eq_nat
    = ( ^ [A3: nat,B2: nat] :
          ( ( ord_less_nat @ A3 @ B2 )
          | ( A3 = B2 ) ) ) ) ).

% order.order_iff_strict
thf(fact_208_order_Ostrict__trans2,axiom,
    ! [A: nat,B: nat,C: nat] :
      ( ( ord_less_nat @ A @ B )
     => ( ( ord_less_eq_nat @ B @ C )
       => ( ord_less_nat @ A @ C ) ) ) ).

% order.strict_trans2
thf(fact_209_order_Ostrict__trans1,axiom,
    ! [A: nat,B: nat,C: nat] :
      ( ( ord_less_eq_nat @ A @ B )
     => ( ( ord_less_nat @ B @ C )
       => ( ord_less_nat @ A @ C ) ) ) ).

% order.strict_trans1
thf(fact_210_not__le__imp__less,axiom,
    ! [Y2: nat,X2: nat] :
      ( ~ ( ord_less_eq_nat @ Y2 @ X2 )
     => ( ord_less_nat @ X2 @ Y2 ) ) ).

% not_le_imp_less
thf(fact_211_less__le__not__le,axiom,
    ( ord_less_nat
    = ( ^ [X3: nat,Y5: nat] :
          ( ( ord_less_eq_nat @ X3 @ Y5 )
          & ~ ( ord_less_eq_nat @ Y5 @ X3 ) ) ) ) ).

% less_le_not_le
thf(fact_212_le__imp__less__or__eq,axiom,
    ! [X2: nat,Y2: nat] :
      ( ( ord_less_eq_nat @ X2 @ Y2 )
     => ( ( ord_less_nat @ X2 @ Y2 )
        | ( X2 = Y2 ) ) ) ).

% le_imp_less_or_eq
thf(fact_213_le__less__linear,axiom,
    ! [X2: nat,Y2: nat] :
      ( ( ord_less_eq_nat @ X2 @ Y2 )
      | ( ord_less_nat @ Y2 @ X2 ) ) ).

% le_less_linear
thf(fact_214_less__le__trans,axiom,
    ! [X2: nat,Y2: nat,Z3: nat] :
      ( ( ord_less_nat @ X2 @ Y2 )
     => ( ( ord_less_eq_nat @ Y2 @ Z3 )
       => ( ord_less_nat @ X2 @ Z3 ) ) ) ).

% less_le_trans
thf(fact_215_le__less__trans,axiom,
    ! [X2: nat,Y2: nat,Z3: nat] :
      ( ( ord_less_eq_nat @ X2 @ Y2 )
     => ( ( ord_less_nat @ Y2 @ Z3 )
       => ( ord_less_nat @ X2 @ Z3 ) ) ) ).

% le_less_trans
thf(fact_216_less__imp__le,axiom,
    ! [X2: nat,Y2: nat] :
      ( ( ord_less_nat @ X2 @ Y2 )
     => ( ord_less_eq_nat @ X2 @ Y2 ) ) ).

% less_imp_le
thf(fact_217_antisym__conv2,axiom,
    ! [X2: nat,Y2: nat] :
      ( ( ord_less_eq_nat @ X2 @ Y2 )
     => ( ( ~ ( ord_less_nat @ X2 @ Y2 ) )
        = ( X2 = Y2 ) ) ) ).

% antisym_conv2
thf(fact_218_antisym__conv1,axiom,
    ! [X2: nat,Y2: nat] :
      ( ~ ( ord_less_nat @ X2 @ Y2 )
     => ( ( ord_less_eq_nat @ X2 @ Y2 )
        = ( X2 = Y2 ) ) ) ).

% antisym_conv1
thf(fact_219_le__neq__trans,axiom,
    ! [A: nat,B: nat] :
      ( ( ord_less_eq_nat @ A @ B )
     => ( ( A != B )
       => ( ord_less_nat @ A @ B ) ) ) ).

% le_neq_trans
thf(fact_220_not__less,axiom,
    ! [X2: nat,Y2: nat] :
      ( ( ~ ( ord_less_nat @ X2 @ Y2 ) )
      = ( ord_less_eq_nat @ Y2 @ X2 ) ) ).

% not_less
thf(fact_221_not__le,axiom,
    ! [X2: nat,Y2: nat] :
      ( ( ~ ( ord_less_eq_nat @ X2 @ Y2 ) )
      = ( ord_less_nat @ Y2 @ X2 ) ) ).

% not_le
thf(fact_222_order__less__le__subst2,axiom,
    ! [A: nat,B: nat,F: nat > nat,C: nat] :
      ( ( ord_less_nat @ A @ B )
     => ( ( ord_less_eq_nat @ ( F @ B ) @ C )
       => ( ! [X5: nat,Y3: nat] :
              ( ( ord_less_nat @ X5 @ Y3 )
             => ( ord_less_nat @ ( F @ X5 ) @ ( F @ Y3 ) ) )
         => ( ord_less_nat @ ( F @ A ) @ C ) ) ) ) ).

% order_less_le_subst2
thf(fact_223_order__less__le__subst1,axiom,
    ! [A: nat,F: nat > nat,B: nat,C: nat] :
      ( ( ord_less_nat @ A @ ( F @ B ) )
     => ( ( ord_less_eq_nat @ B @ C )
       => ( ! [X5: nat,Y3: nat] :
              ( ( ord_less_eq_nat @ X5 @ Y3 )
             => ( ord_less_eq_nat @ ( F @ X5 ) @ ( F @ Y3 ) ) )
         => ( ord_less_nat @ A @ ( F @ C ) ) ) ) ) ).

% order_less_le_subst1
thf(fact_224_order__le__less__subst2,axiom,
    ! [A: nat,B: nat,F: nat > nat,C: nat] :
      ( ( ord_less_eq_nat @ A @ B )
     => ( ( ord_less_nat @ ( F @ B ) @ C )
       => ( ! [X5: nat,Y3: nat] :
              ( ( ord_less_eq_nat @ X5 @ Y3 )
             => ( ord_less_eq_nat @ ( F @ X5 ) @ ( F @ Y3 ) ) )
         => ( ord_less_nat @ ( F @ A ) @ C ) ) ) ) ).

% order_le_less_subst2
thf(fact_225_order__le__less__subst1,axiom,
    ! [A: nat,F: nat > nat,B: nat,C: nat] :
      ( ( ord_less_eq_nat @ A @ ( F @ B ) )
     => ( ( ord_less_nat @ B @ C )
       => ( ! [X5: nat,Y3: nat] :
              ( ( ord_less_nat @ X5 @ Y3 )
             => ( ord_less_nat @ ( F @ X5 ) @ ( F @ Y3 ) ) )
         => ( ord_less_nat @ A @ ( F @ C ) ) ) ) ) ).

% order_le_less_subst1
thf(fact_226_less__le,axiom,
    ( ord_less_nat
    = ( ^ [X3: nat,Y5: nat] :
          ( ( ord_less_eq_nat @ X3 @ Y5 )
          & ( X3 != Y5 ) ) ) ) ).

% less_le
thf(fact_227_le__less,axiom,
    ( ord_less_eq_nat
    = ( ^ [X3: nat,Y5: nat] :
          ( ( ord_less_nat @ X3 @ Y5 )
          | ( X3 = Y5 ) ) ) ) ).

% le_less
thf(fact_228_leI,axiom,
    ! [X2: nat,Y2: nat] :
      ( ~ ( ord_less_nat @ X2 @ Y2 )
     => ( ord_less_eq_nat @ Y2 @ X2 ) ) ).

% leI
thf(fact_229_leD,axiom,
    ! [Y2: nat,X2: nat] :
      ( ( ord_less_eq_nat @ Y2 @ X2 )
     => ~ ( ord_less_nat @ X2 @ Y2 ) ) ).

% leD
thf(fact_230_pinf_I6_J,axiom,
    ! [T: nat] :
    ? [Z2: nat] :
    ! [X6: nat] :
      ( ( ord_less_nat @ Z2 @ X6 )
     => ~ ( ord_less_eq_nat @ X6 @ T ) ) ).

% pinf(6)
thf(fact_231_pinf_I8_J,axiom,
    ! [T: nat] :
    ? [Z2: nat] :
    ! [X6: nat] :
      ( ( ord_less_nat @ Z2 @ X6 )
     => ( ord_less_eq_nat @ T @ X6 ) ) ).

% pinf(8)
thf(fact_232_minf_I6_J,axiom,
    ! [T: nat] :
    ? [Z2: nat] :
    ! [X6: nat] :
      ( ( ord_less_nat @ X6 @ Z2 )
     => ( ord_less_eq_nat @ X6 @ T ) ) ).

% minf(6)
thf(fact_233_complete__interval,axiom,
    ! [A: nat,B: nat,P: nat > $o] :
      ( ( ord_less_nat @ A @ B )
     => ( ( P @ A )
       => ( ~ ( P @ B )
         => ? [C2: nat] :
              ( ( ord_less_eq_nat @ A @ C2 )
              & ( ord_less_eq_nat @ C2 @ B )
              & ! [X6: nat] :
                  ( ( ( ord_less_eq_nat @ A @ X6 )
                    & ( ord_less_nat @ X6 @ C2 ) )
                 => ( P @ X6 ) )
              & ! [D: nat] :
                  ( ! [X5: nat] :
                      ( ( ( ord_less_eq_nat @ A @ X5 )
                        & ( ord_less_nat @ X5 @ D ) )
                     => ( P @ X5 ) )
                 => ( ord_less_eq_nat @ D @ C2 ) ) ) ) ) ) ).

% complete_interval
thf(fact_234_verit__comp__simplify1_I3_J,axiom,
    ! [B4: nat,A5: nat] :
      ( ( ~ ( ord_less_eq_nat @ B4 @ A5 ) )
      = ( ord_less_nat @ A5 @ B4 ) ) ).

% verit_comp_simplify1(3)
thf(fact_235_set__swap,axiom,
    ! [I3: nat,Xs: list_nat,J: nat] :
      ( ( ord_less_nat @ I3 @ ( size_size_list_nat @ Xs ) )
     => ( ( ord_less_nat @ J @ ( size_size_list_nat @ Xs ) )
       => ( ( set_nat2 @ ( list_update_nat @ ( list_update_nat @ Xs @ I3 @ ( nth_nat @ Xs @ J ) ) @ J @ ( nth_nat @ Xs @ I3 ) ) )
          = ( set_nat2 @ Xs ) ) ) ) ).

% set_swap
thf(fact_236_set__swap,axiom,
    ! [I3: nat,Xs: list_a,J: nat] :
      ( ( ord_less_nat @ I3 @ ( size_size_list_a @ Xs ) )
     => ( ( ord_less_nat @ J @ ( size_size_list_a @ Xs ) )
       => ( ( set_a2 @ ( list_update_a @ ( list_update_a @ Xs @ I3 @ ( nth_a @ Xs @ J ) ) @ J @ ( nth_a @ Xs @ I3 ) ) )
          = ( set_a2 @ Xs ) ) ) ) ).

% set_swap
thf(fact_237_butlast__list__update,axiom,
    ! [K: nat,Xs: list_nat,X2: nat] :
      ( ( ( K
          = ( minus_minus_nat @ ( size_size_list_nat @ Xs ) @ one_one_nat ) )
       => ( ( butlast_nat @ ( list_update_nat @ Xs @ K @ X2 ) )
          = ( butlast_nat @ Xs ) ) )
      & ( ( K
         != ( minus_minus_nat @ ( size_size_list_nat @ Xs ) @ one_one_nat ) )
       => ( ( butlast_nat @ ( list_update_nat @ Xs @ K @ X2 ) )
          = ( list_update_nat @ ( butlast_nat @ Xs ) @ K @ X2 ) ) ) ) ).

% butlast_list_update
thf(fact_238_butlast__list__update,axiom,
    ! [K: nat,Xs: list_a,X2: a] :
      ( ( ( K
          = ( minus_minus_nat @ ( size_size_list_a @ Xs ) @ one_one_nat ) )
       => ( ( butlast_a @ ( list_update_a @ Xs @ K @ X2 ) )
          = ( butlast_a @ Xs ) ) )
      & ( ( K
         != ( minus_minus_nat @ ( size_size_list_a @ Xs ) @ one_one_nat ) )
       => ( ( butlast_a @ ( list_update_a @ Xs @ K @ X2 ) )
          = ( list_update_a @ ( butlast_a @ Xs ) @ K @ X2 ) ) ) ) ).

% butlast_list_update
thf(fact_239_length__butlast,axiom,
    ! [Xs: list_nat] :
      ( ( size_size_list_nat @ ( butlast_nat @ Xs ) )
      = ( minus_minus_nat @ ( size_size_list_nat @ Xs ) @ one_one_nat ) ) ).

% length_butlast
thf(fact_240_length__butlast,axiom,
    ! [Xs: list_a] :
      ( ( size_size_list_a @ ( butlast_a @ Xs ) )
      = ( minus_minus_nat @ ( size_size_list_a @ Xs ) @ one_one_nat ) ) ).

% length_butlast
thf(fact_241_subset__code_I1_J,axiom,
    ! [Xs: list_a,B5: set_a] :
      ( ( ord_less_eq_set_a @ ( set_a2 @ Xs ) @ B5 )
      = ( ! [X3: a] :
            ( ( member_a @ X3 @ ( set_a2 @ Xs ) )
           => ( member_a @ X3 @ B5 ) ) ) ) ).

% subset_code(1)
thf(fact_242_set__update__subsetI,axiom,
    ! [Xs: list_a,A2: set_a,X2: a,I3: nat] :
      ( ( ord_less_eq_set_a @ ( set_a2 @ Xs ) @ A2 )
     => ( ( member_a @ X2 @ A2 )
       => ( ord_less_eq_set_a @ ( set_a2 @ ( list_update_a @ Xs @ I3 @ X2 ) ) @ A2 ) ) ) ).

% set_update_subsetI
thf(fact_243_in__set__butlastD,axiom,
    ! [X2: a,Xs: list_a] :
      ( ( member_a @ X2 @ ( set_a2 @ ( butlast_a @ Xs ) ) )
     => ( member_a @ X2 @ ( set_a2 @ Xs ) ) ) ).

% in_set_butlastD
thf(fact_244_one__reorient,axiom,
    ! [X2: nat] :
      ( ( one_one_nat = X2 )
      = ( X2 = one_one_nat ) ) ).

% one_reorient
thf(fact_245_list__ex__cong,axiom,
    ! [Xs: list_a,Ys: list_a,F: a > $o,G: a > $o] :
      ( ( Xs = Ys )
     => ( ! [X5: a] :
            ( ( member_a @ X5 @ ( set_a2 @ Ys ) )
           => ( ( F @ X5 )
              = ( G @ X5 ) ) )
       => ( ( list_ex_a @ F @ Xs )
          = ( list_ex_a @ G @ Ys ) ) ) ) ).

% list_ex_cong
thf(fact_246_in__set__butlast__appendI,axiom,
    ! [X2: a,Xs: list_a,Ys: list_a] :
      ( ( ( member_a @ X2 @ ( set_a2 @ ( butlast_a @ Xs ) ) )
        | ( member_a @ X2 @ ( set_a2 @ ( butlast_a @ Ys ) ) ) )
     => ( member_a @ X2 @ ( set_a2 @ ( butlast_a @ ( append_a @ Xs @ Ys ) ) ) ) ) ).

% in_set_butlast_appendI
thf(fact_247_nth__mem,axiom,
    ! [N: nat,Xs: list_nat] :
      ( ( ord_less_nat @ N @ ( size_size_list_nat @ Xs ) )
     => ( member_nat @ ( nth_nat @ Xs @ N ) @ ( set_nat2 @ Xs ) ) ) ).

% nth_mem
thf(fact_248_nth__mem,axiom,
    ! [N: nat,Xs: list_a] :
      ( ( ord_less_nat @ N @ ( size_size_list_a @ Xs ) )
     => ( member_a @ ( nth_a @ Xs @ N ) @ ( set_a2 @ Xs ) ) ) ).

% nth_mem
thf(fact_249_list__ball__nth,axiom,
    ! [N: nat,Xs: list_nat,P: nat > $o] :
      ( ( ord_less_nat @ N @ ( size_size_list_nat @ Xs ) )
     => ( ! [X5: nat] :
            ( ( member_nat @ X5 @ ( set_nat2 @ Xs ) )
           => ( P @ X5 ) )
       => ( P @ ( nth_nat @ Xs @ N ) ) ) ) ).

% list_ball_nth
thf(fact_250_list__ball__nth,axiom,
    ! [N: nat,Xs: list_a,P: a > $o] :
      ( ( ord_less_nat @ N @ ( size_size_list_a @ Xs ) )
     => ( ! [X5: a] :
            ( ( member_a @ X5 @ ( set_a2 @ Xs ) )
           => ( P @ X5 ) )
       => ( P @ ( nth_a @ Xs @ N ) ) ) ) ).

% list_ball_nth
thf(fact_251_in__set__conv__nth,axiom,
    ! [X2: nat,Xs: list_nat] :
      ( ( member_nat @ X2 @ ( set_nat2 @ Xs ) )
      = ( ? [I2: nat] :
            ( ( ord_less_nat @ I2 @ ( size_size_list_nat @ Xs ) )
            & ( ( nth_nat @ Xs @ I2 )
              = X2 ) ) ) ) ).

% in_set_conv_nth
thf(fact_252_in__set__conv__nth,axiom,
    ! [X2: a,Xs: list_a] :
      ( ( member_a @ X2 @ ( set_a2 @ Xs ) )
      = ( ? [I2: nat] :
            ( ( ord_less_nat @ I2 @ ( size_size_list_a @ Xs ) )
            & ( ( nth_a @ Xs @ I2 )
              = X2 ) ) ) ) ).

% in_set_conv_nth
thf(fact_253_all__nth__imp__all__set,axiom,
    ! [Xs: list_nat,P: nat > $o,X2: nat] :
      ( ! [I: nat] :
          ( ( ord_less_nat @ I @ ( size_size_list_nat @ Xs ) )
         => ( P @ ( nth_nat @ Xs @ I ) ) )
     => ( ( member_nat @ X2 @ ( set_nat2 @ Xs ) )
       => ( P @ X2 ) ) ) ).

% all_nth_imp_all_set
thf(fact_254_all__nth__imp__all__set,axiom,
    ! [Xs: list_a,P: a > $o,X2: a] :
      ( ! [I: nat] :
          ( ( ord_less_nat @ I @ ( size_size_list_a @ Xs ) )
         => ( P @ ( nth_a @ Xs @ I ) ) )
     => ( ( member_a @ X2 @ ( set_a2 @ Xs ) )
       => ( P @ X2 ) ) ) ).

% all_nth_imp_all_set
thf(fact_255_all__set__conv__all__nth,axiom,
    ! [Xs: list_nat,P: nat > $o] :
      ( ( ! [X3: nat] :
            ( ( member_nat @ X3 @ ( set_nat2 @ Xs ) )
           => ( P @ X3 ) ) )
      = ( ! [I2: nat] :
            ( ( ord_less_nat @ I2 @ ( size_size_list_nat @ Xs ) )
           => ( P @ ( nth_nat @ Xs @ I2 ) ) ) ) ) ).

% all_set_conv_all_nth
thf(fact_256_all__set__conv__all__nth,axiom,
    ! [Xs: list_a,P: a > $o] :
      ( ( ! [X3: a] :
            ( ( member_a @ X3 @ ( set_a2 @ Xs ) )
           => ( P @ X3 ) ) )
      = ( ! [I2: nat] :
            ( ( ord_less_nat @ I2 @ ( size_size_list_a @ Xs ) )
           => ( P @ ( nth_a @ Xs @ I2 ) ) ) ) ) ).

% all_set_conv_all_nth
thf(fact_257_verit__la__disequality,axiom,
    ! [A: nat,B: nat] :
      ( ( A = B )
      | ~ ( ord_less_eq_nat @ A @ B )
      | ~ ( ord_less_eq_nat @ B @ A ) ) ).

% verit_la_disequality

% Helper facts (5)
thf(help_If_2_1_If_001tf__a_T,axiom,
    ! [X2: a,Y2: a] :
      ( ( if_a @ $false @ X2 @ Y2 )
      = Y2 ) ).

thf(help_If_1_1_If_001tf__a_T,axiom,
    ! [X2: a,Y2: a] :
      ( ( if_a @ $true @ X2 @ Y2 )
      = X2 ) ).

thf(help_If_3_1_If_001t__Nat__Onat_T,axiom,
    ! [P: $o] :
      ( ( P = $true )
      | ( P = $false ) ) ).

thf(help_If_2_1_If_001t__Nat__Onat_T,axiom,
    ! [X2: nat,Y2: nat] :
      ( ( if_nat @ $false @ X2 @ Y2 )
      = Y2 ) ).

thf(help_If_1_1_If_001t__Nat__Onat_T,axiom,
    ! [X2: nat,Y2: nat] :
      ( ( if_nat @ $true @ X2 @ Y2 )
      = X2 ) ).

% Conjectures (4)
thf(conj_0,hypothesis,
    ( ( size_size_list_a @ xs )
    = ( size_size_list_a @ ys ) ) ).

thf(conj_1,hypothesis,
    ! [X6: nat] :
      ( ( ( ord_less_nat @ X6 @ ( size_size_list_a @ ys ) )
       => ( ( ( ord_less_nat @ X6 @ ( size_size_list_a @ ys ) )
           => ( ( nth_a @ xs @ X6 )
              = ( nth_a @ ys @ X6 ) ) )
          & ( ~ ( ord_less_nat @ X6 @ ( size_size_list_a @ ys ) )
           => ( ( f @ ( minus_minus_nat @ X6 @ ( size_size_list_a @ xs ) ) )
              = ( nth_a @ ys @ X6 ) ) ) ) )
      & ( ~ ( ord_less_nat @ X6 @ ( size_size_list_a @ ys ) )
       => ( ( ( ord_less_nat @ X6 @ ( size_size_list_a @ ys ) )
           => ( ( nth_a @ xs @ X6 )
              = ( g @ ( minus_minus_nat @ X6 @ ( size_size_list_a @ ys ) ) ) ) )
          & ( ~ ( ord_less_nat @ X6 @ ( size_size_list_a @ ys ) )
           => ( ( f @ ( minus_minus_nat @ X6 @ ( size_size_list_a @ xs ) ) )
              = ( g @ ( minus_minus_nat @ X6 @ ( size_size_list_a @ ys ) ) ) ) ) ) ) ) ).

thf(conj_2,hypothesis,
    ord_less_nat @ x @ ( size_size_list_a @ ys ) ).

thf(conj_3,conjecture,
    ( ( nth_a @ xs @ x )
    = ( nth_a @ ys @ x ) ) ).

%------------------------------------------------------------------------------
